/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.common.validation.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ValidatorUtils {
    private static final String SCHEMATRON_TEXT = "iso_schematron_text.xsl";
    private static final String SCHEMATRON_SKELETON = "iso_schematron_skeleton.xsl";

    public static File getTempFileFromSchemaName(String schemaFileName) {
        InputStream in = ValidatorUtils.class.getResourceAsStream("/sdd_schema/" + schemaFileName);
        if (in == null) {
            try {
                in = new File("sdd_schema/" + schemaFileName).toURL().openStream();
            }
            catch (Exception exception) {
                return null;
            }
        }
        File tempFile = null;
        try {
            tempFile = File.createTempFile(schemaFileName, null);
        }
        catch (IOException iOException) {
            return null;
        }
        tempFile.deleteOnExit();
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(tempFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        byte[] copyBuffer = new byte[1024];
        int bytesRead = 0;
        try {
            while ((bytesRead = in.read(copyBuffer)) != -1) {
                ((OutputStream)out).write(copyBuffer, 0, bytesRead);
            }
            in.close();
            ((OutputStream)out).close();
        }
        catch (IOException iOException) {
            return null;
        }
        return tempFile;
    }

    public static File getTempFileFromSchematronText() {
        InputStream skeletonIn = ValidatorUtils.class.getResourceAsStream("/schematron/iso_schematron_skeleton.xsl");
        InputStream textIn = ValidatorUtils.class.getResourceAsStream("/schematron/iso_schematron_text.xsl");
        if (skeletonIn == null) {
            try {
                skeletonIn = new File("schematron/iso_schematron_skeleton.xsl").toURL().openStream();
            }
            catch (Exception exception) {
                return null;
            }
        }
        if (textIn == null) {
            try {
                textIn = new File("schematron/iso_schematron_text.xsl").toURL().openStream();
            }
            catch (Exception exception) {
                return null;
            }
        }
        File skeletonTempFile = null;
        try {
            skeletonTempFile = File.createTempFile(SCHEMATRON_SKELETON, null);
        }
        catch (IOException iOException) {
            return null;
        }
        skeletonTempFile.deleteOnExit();
        File textTempFile = null;
        try {
            textTempFile = File.createTempFile(SCHEMATRON_TEXT, null);
        }
        catch (IOException iOException) {
            return null;
        }
        textTempFile.deleteOnExit();
        FileOutputStream skeletonOut = null;
        try {
            skeletonOut = new FileOutputStream(skeletonTempFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        FileOutputStream textOut = null;
        try {
            textOut = new FileOutputStream(textTempFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        byte[] copyBuffer = new byte[1024];
        int bytesRead = 0;
        try {
            while ((bytesRead = skeletonIn.read(copyBuffer)) != -1) {
                ((OutputStream)skeletonOut).write(copyBuffer, 0, bytesRead);
            }
            skeletonIn.close();
            ((OutputStream)skeletonOut).close();
        }
        catch (IOException iOException) {
            return null;
        }
        bytesRead = 0;
        String textContents = new String();
        try {
            while ((bytesRead = textIn.read(copyBuffer)) != -1) {
                textContents = String.valueOf(textContents) + new String(copyBuffer, 0, bytesRead);
            }
            textIn.close();
        }
        catch (IOException iOException) {
            return null;
        }
        String skeletonPath = skeletonTempFile.getAbsolutePath().replaceAll("\\\\", "\\\\\\\\");
        textContents = textContents.replaceFirst("<xsl:import href=\"iso_schematron_skeleton.xsl\"/>", "<xsl:import href=\"" + skeletonPath + "\"/>");
        try {
            ((OutputStream)textOut).write(textContents.getBytes());
        }
        catch (IOException iOException) {
            return null;
        }
        return textTempFile;
    }

    public static Element findElement(Node rootElement, String elementName) {
        if (rootElement instanceof Document) {
            return ValidatorUtils.findElement(((Document)rootElement).getDocumentElement(), elementName);
        }
        if (rootElement instanceof Element && ValidatorUtils.nodeNameEquals(rootElement, elementName)) {
            return (Element)rootElement;
        }
        NodeList nodes = rootElement.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node instanceof Element) {
                if (node.getNodeName() != null && ValidatorUtils.nodeNameEquals(node, elementName)) {
                    return (Element)node;
                }
                if (node.getChildNodes().getLength() > 0) {
                    NodeList childNodes = node.getChildNodes();
                    int j = 0;
                    while (j < childNodes.getLength()) {
                        Element childNode = ValidatorUtils.findElement(childNodes.item(j), elementName);
                        if (childNode != null) {
                            return childNode;
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        return null;
    }

    public static boolean nodeNameEquals(Node node, String nodeName) {
        String name = node.getNodeName();
        if (name.indexOf(58) != -1) {
            name = name.substring(name.indexOf(58) + 1, name.length());
        }
        return nodeName.equals(name);
    }
}

