/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.tests.common.validation;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.cosmos.me.sdd.common.validation.plugin.SchematronValidationRule;
import org.eclipse.cosmos.me.sdd.tests.common.validation.AllTests;

public class SchematronValidationRule_Test
extends TestCase {
    private static String FSEP = System.getProperty("file.separator");
    private static final String VALID_DD_SCHEMATRON = String.valueOf(AllTests.ARTIFACT_LOCATION) + FSEP + "Valid_SchematronRules_DD.sch";
    private static final String VALID_PD_SCHEMATRON = String.valueOf(AllTests.ARTIFACT_LOCATION) + FSEP + "Valid_SchematronRules_PD.sch";
    private static final String INVALID_SCHEMATRON = String.valueOf(AllTests.ARTIFACT_LOCATION) + FSEP + "Invalid_SchematronRules.sch";

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testSchematronValidationRule_ExistingFiles() throws FileNotFoundException, IOException {
        File rulesFile = new File(VALID_DD_SCHEMATRON);
        SchematronValidationRule validationRule = new SchematronValidationRule(rulesFile);
        SchematronValidationRule_Test.assertNotNull((Object)validationRule);
    }

    public void testSchematronValidationRule_MissingRules() throws IOException {
        File rulesFile = new File(String.valueOf(AllTests.ARTIFACT_LOCATION) + FSEP + "Valid_SchematronRules.sch-NotHere");
        try {
            new SchematronValidationRule(rulesFile);
            SchematronValidationRule_Test.fail((String)"Schemetron rules file is missing but FileNotFoundException was not thrown");
        }
        catch (FileNotFoundException fileNotFoundException) {}
    }

    public void testValidate_ValidDD() throws FileNotFoundException, IOException {
        File rulesFile = new File(VALID_DD_SCHEMATRON);
        SchematronValidationRule validationRule = new SchematronValidationRule(rulesFile);
        File xmlFile = new File(AllTests.VALID_DD);
        SchematronValidationRule_Test.assertEquals((int)validationRule.validate(new FileInputStream(xmlFile)).size(), (int)0);
    }

    public void testValidate_ValidPD() throws FileNotFoundException, IOException {
        File rulesFile = new File(VALID_PD_SCHEMATRON);
        SchematronValidationRule validationRule = new SchematronValidationRule(rulesFile);
        File xmlFile = new File(AllTests.VALID_PD);
        SchematronValidationRule_Test.assertEquals((int)validationRule.validate(new FileInputStream(xmlFile)).size(), (int)0);
    }

    public void testValidate_InvalidSchematron() throws FileNotFoundException, IOException {
        File rulesFile = new File(INVALID_SCHEMATRON);
        SchematronValidationRule validationRule = new SchematronValidationRule(rulesFile);
        File xmlFile = new File(AllTests.VALID_DD);
        SchematronValidationRule_Test.assertFalse((validationRule.validate(new FileInputStream(xmlFile)).size() == 0 ? 1 : 0) != 0);
    }
}

