package org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

import org.eclipse.cosmos.me.sdd.schema.VersionValueType;

public class VersionValueCompare
{

	protected static Collection<VersionValueType> merge(List<VersionValueType> value, List<VersionValueType> value2)
	{
		Vector <VersionValueType> toRemove = new Vector <VersionValueType> ();
		Iterator <VersionValueType> iter1 = value.iterator();		
		//iterate through the items
		while (iter1.hasNext())
		{
			VersionValueType o1 = (VersionValueType) iter1.next();
			Iterator <VersionValueType> iter2 = value2.iterator();
			while (iter2.hasNext())
			{
				VersionValueType o2 = (VersionValueType) iter2.next();
				//if you find a match that hasn't been found, note it
				//one of the equals needs to be deleted with its children merged over
				if (toRemove.contains(o2)==false)
				{
					if (equals(o1, o2))
					{  
						toRemove.add(o2);
					}
				}
					
			}
		}
		
		value2.removeAll(toRemove);
		//remove all of the matches that were found
		
		Vector <VersionValueType> finals = new Vector <VersionValueType> ();
		//create and return a new collection with all of the remaining items
		finals.addAll(value);
		finals.addAll(value2);		
		
		return finals;
	}

	protected static boolean equals(VersionValueType vv, VersionValueType vv2)
	{
		if (!StringCompare.equals(vv.getFixName(),vv2.getFixName()))
			return false;
		if (!StringCompare.equals(vv.getVersion(),vv2.getVersion()))
			return false;
		return true;
	}

}
