package org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons;

import java.util.Iterator;
import java.util.Vector;

import org.eclipse.cosmos.me.sdd.schema.BooleanParameterType;
import org.eclipse.cosmos.me.sdd.schema.IntegerParameterType;
import org.eclipse.cosmos.me.sdd.schema.ObjectFactory;
import org.eclipse.cosmos.me.sdd.schema.ParametersType;
import org.eclipse.cosmos.me.sdd.schema.StringParameterType;
import org.eclipse.cosmos.me.sdd.schema.URIParameterType;

public class ParametersCompare
{

	public static ParametersType merge(Vector<ParametersType> parameters1,Vector<ParametersType> parameters2)
	{
		ObjectFactory objectFactory = new ObjectFactory();
		ParametersType merged = objectFactory.createParametersType();
		
		//get parameter types out and merge em.
		Vector <IntegerParameterType> ints1 = new Vector <IntegerParameterType>();
		Vector <IntegerParameterType> ints2 = new Vector <IntegerParameterType>();
		Vector <StringParameterType> strings1 = new Vector <StringParameterType>();
		Vector <StringParameterType> strings2 = new Vector <StringParameterType>();
		Vector <BooleanParameterType> bools1 = new Vector <BooleanParameterType>();
		Vector <BooleanParameterType> bools2 = new Vector <BooleanParameterType>();
		Vector <URIParameterType> uris1 = new Vector <URIParameterType>();
		Vector <URIParameterType> uris2 = new Vector <URIParameterType>();
		
		Iterator <ParametersType> iter1 = parameters1.iterator();
		Iterator <ParametersType> iter2 = parameters2.iterator();
		
		while (iter1.hasNext())
		{
			ParametersType p = iter1.next();
			
			Iterator <Object> pIter = p.getIntegerParameterOrStringParameterOrBooleanParameter().iterator();
			while (pIter.hasNext())
			{
				Object o = pIter.next();
				
				if (o instanceof IntegerParameterType)
					ints1.add((IntegerParameterType)o);
				if (o instanceof StringParameterType)
					strings1.add((StringParameterType)o);
				if (o instanceof BooleanParameterType)
					bools1.add((BooleanParameterType)o);
				if (o instanceof URIParameterType)
					uris1.add((URIParameterType)o);
			}
		}
		
		while (iter2.hasNext())
		{
			ParametersType p = iter2.next();
			
			Iterator <Object> pIter = p.getIntegerParameterOrStringParameterOrBooleanParameter().iterator();
			while (pIter.hasNext())
			{
				Object o = pIter.next();
				
				if (o instanceof IntegerParameterType)
					ints2.add((IntegerParameterType)o);
				if (o instanceof StringParameterType)
					strings2.add((StringParameterType)o);
				if (o instanceof BooleanParameterType)
					bools2.add((BooleanParameterType)o);
				if (o instanceof URIParameterType)
					uris2.add((URIParameterType)o);
			}
		}
		
		merged.getIntegerParameterOrStringParameterOrBooleanParameter().addAll(IntegerParameterCompare.merge(ints1,ints2));
		merged.getIntegerParameterOrStringParameterOrBooleanParameter().addAll(StringParameterCompare.merge(strings1,strings2));
		merged.getIntegerParameterOrStringParameterOrBooleanParameter().addAll(BooleanParameterCompare.merge(bools1,bools2));
		merged.getIntegerParameterOrStringParameterOrBooleanParameter().addAll(URIParameterCompare.merge(uris1,uris2));
		
		
		return merged;
	}

}
