/*******************************************************************************
 * Copyright (c) 2008 CA
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     CA Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.internal.stat.datamgr.client;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axis2.AxisFault;
import org.apache.axis2.Constants;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.eclipse.cosmos.dc.internal.stat.datamgr.common.DataSourceKeyset;
import java.util.Date;
import java.text.DateFormat;
import java.text.SimpleDateFormat;

import org.eclipse.cosmos.common.provisional.exceptions.CosmosException;

public class StatisticalDataManagerClient implements IStatisticalClient {
	private EndpointReference epr;
	private ServiceClient sender;
	public static final String DM_NAMESPACE = "http://datamgr.stat.internal.dc.cosmos.eclipse.org";
	
	public StatisticalDataManagerClient(String eprstr) throws CosmosException
	{
		this.epr = new EndpointReference(eprstr);
		Init();
	}
	
	
	public Collection<DataSourceKeyset> getDatasourceKeyset() throws CosmosException
	{
		Collection<DataSourceKeyset> ret = null;
		OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace(DM_NAMESPACE, "tns");
        OMElement tsRequest = fac.createOMElement("getDatasourceKeysets", omNs);

        OMElement result = null;
        try {
        	result = sender.sendReceive(tsRequest);
        } catch (AxisFault a) {
        	throw new CosmosException(a);
        }
        
       	Iterator Iter = result.getChildElements();
        ret = processGDK(Iter);
        return ret; 
	}
	
	public Collection<StatisticalTuple> getStatDataForSource(String dataset,String keyset, int start, int size) throws CosmosException
	{
		Collection<StatisticalTuple> ret = null;
		OMFactory fac = OMAbstractFactory.getOMFactory();
        OMNamespace omNs = fac.createOMNamespace(DM_NAMESPACE, "tns");
        OMElement tsRequest = fac.createOMElement("getStatDataForSources", omNs);

        OMElement value1 = fac.createOMElement("dataset", omNs);
        value1.addChild(fac.createOMText(value1, dataset));
        tsRequest.addChild(value1);
        
        value1 = fac.createOMElement("keyset", omNs);
        value1.addChild(fac.createOMText(value1, keyset));
        tsRequest.addChild(value1);
        
        value1 = fac.createOMElement("start", omNs);
        value1.addChild(fac.createOMText(value1, String.valueOf(start)));
        tsRequest.addChild(value1);
        
        value1 = fac.createOMElement("size", omNs);
        value1.addChild(fac.createOMText(value1, String.valueOf(size)));
        tsRequest.addChild(value1);
        
        OMElement result = null;
        try {
        	result = sender.sendReceive(tsRequest);
        } catch (AxisFault a) {
        	throw new CosmosException("AxisFault");
        }
        Iterator Iter = result.getChildElements();
        ret = processSDFS(Iter);
        return ret; 
	}

	private void Init() throws CosmosException
	{
		Options options = new Options();
		options.setTo(epr);
		options.setTransportInProtocol(Constants.TRANSPORT_HTTP);
		try {
			sender = new ServiceClient();
		} catch (AxisFault a) {
			throw new CosmosException("AxisFault");
		}
		sender.setOptions(options);
	}
	private Collection<DataSourceKeyset> processGDK(Iterator Iter) 
	{
		ArrayList<DataSourceKeyset> ret = new ArrayList();
		PopulateGDK(Iter,ret);
		return ret;
	}
	private Collection<StatisticalTuple> processSDFS(Iterator Iter) throws CosmosException
	{
		ArrayList<StatisticalTuple> ret = new ArrayList();
		PopulateSDFS(Iter,ret);
		return ret;
	}
	
	private void PopulateSDFS(Iterator Iter,ArrayList<StatisticalTuple> list) throws CosmosException {
		StatisticalTuple tmp = null;
		while (Iter.hasNext()) {
			OMElement elem = (OMElement) Iter.next();
			
			if (elem.getLocalName().equals("CAPTURE_TIME")) {
				tmp = new StatisticalTuple();
				String t = elem.getText();
				Date d = null;
				try {
					SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSS");
					d = sd.parse(t);
				} catch(Exception e) {
					throw new CosmosException("Couldn't parse date " + t);
				}
				tmp.setTimeStamp(d);
				list.add(tmp);
			}
			if (elem.getLocalName().equals("STRING_VALUE")) {
				String t = elem.getText();
				StatisticalObservation s = new StatisticalObservation("string",t);
				tmp.add(s);
			}
			if (elem.getLocalName().equals("INTEGRAL_VALUE")) {
				String t = elem.getText();
				Integer I = new Integer(Integer.valueOf(t));
				StatisticalObservation s = new StatisticalObservation("integer",I);
				tmp.add(s);
			}
			if (elem.getLocalName().equals("DECIMAL_VALUE")) {
				String t = elem.getText();
				Double db = new Double(Double.valueOf(t));
				StatisticalObservation s = new StatisticalObservation("double",db);
				tmp.add(s);
			}
			Iterator n = elem.getChildElements();
			if (n != null) {
				PopulateSDFS(n,list);
			}
		}
	}

	
	private void PopulateGDK(Iterator Iter,ArrayList<DataSourceKeyset> list) {
		DataSourceKeyset tmp = null;
		String d = null;
		String k = null;
		while (Iter.hasNext()) {
			OMElement elem = (OMElement) Iter.next();
			if (elem.getLocalName().equals("Dataset")) {
				String t = elem.getText();
				if ((t != null) && (t.length() > 0)) 
					d = new String(t);
			}
			if (elem.getLocalName().equals("Keyset")) {
				String t = elem.getText();
				if ((t != null) && (t.length() > 0)) 
					k = new String(t);
				
				if (d != null) {
					tmp = new DataSourceKeyset(d,k);
					list.add(tmp);
					d = null;
				}
			}
			Iterator n = elem.getChildElements();
			if (n != null) {
				PopulateGDK(n,list);
			}
		}
	}
}

class TestStatClient {
	public static final String MY_EPR = "http://localhost:8080/org.eclipse.cosmos.dc.internal.stat.datamgr/services/StatisticalDataManager";
	private String _epr = null;
	
	/**
	 * @param args
	 */
	public static void main(String[] args) {
		TestStatClient tc = null;
		if (args.length == 0) 
			tc = new TestStatClient();
		else
			tc = new TestStatClient(args[0]);
		
		tc.testGDK();
		tc.testSDFS();
	}
	
	public TestStatClient() { _epr = new String(MY_EPR); }
	public TestStatClient(String epr) { _epr = new String(epr); }
	
	public void testGDK()
	{
		StatisticalDataManagerClient c = null;
		Iterator Iter = null;
		try {
			c = new StatisticalDataManagerClient(_epr);
		} catch (Exception e) {
			System.out.println("EEK");
			e.printStackTrace();
			return;
		}

		Collection<DataSourceKeyset> ret = null;
		try {
			ret = c.getDatasourceKeyset();
		} catch(Exception e) {
			System.out.println("response trouble.");
			e.printStackTrace();
			return;
		}
		Iterator iter = ret.iterator();
		while (iter.hasNext()) {
			DataSourceKeyset d = (DataSourceKeyset) iter.next();
			System.out.println(d.toString());
		}
	}
	public void testSDFS()
	{
		StatisticalDataManagerClient c = null;
		Iterator Iter = null;
		try {
			c = new StatisticalDataManagerClient(_epr);
		} catch (Exception e) {
			System.out.println("EEK");
			e.printStackTrace();
			return;
		}

		Collection<StatisticalTuple> ret = null;
		String dataset = "server 33 tomcat1181829221515";
		String keyset = "CBE";
		try {
			ret = c.getStatDataForSource(dataset,keyset,0,1000);
		} catch(Exception e) {
			System.out.println("response trouble.");
			e.printStackTrace();
			return;
		}
		Iterator iter = ret.iterator();
		while (iter.hasNext()) {
			StatisticalTuple t = (StatisticalTuple) iter.next();
			System.out.println("Tuple " + t.toString());
		}
	}
}


