/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.derby.client.am.Clob;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.SqlException;

public class ClobLocatorOutputStream
extends OutputStream {
    private final Connection connection;
    private final Clob clob;
    private long currentPos;

    public ClobLocatorOutputStream(Connection connection, Clob clob, long pos) throws SqlException {
        if (pos - 1L > clob.sqlLength()) {
            throw new IndexOutOfBoundsException();
        }
        this.connection = connection;
        this.clob = clob;
        this.currentPos = pos;
    }

    public void write(int b) throws IOException {
        byte[] ba = new byte[]{(byte)b};
        this.writeBytes(ba);
    }

    public void write(byte[] b) throws IOException {
        this.writeBytes(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return;
        }
        if (off < 0 || off > b.length || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        byte[] ba = b;
        if (off > 0 || len < b.length) {
            ba = new byte[len];
            System.arraycopy(b, off, ba, 0, len);
        }
        this.writeBytes(ba);
    }

    public void flush() {
    }

    private void writeBytes(byte[] b) throws IOException {
        try {
            String clobStr = new String(b, "ISO-8859-1");
            this.clob.setStringX(this.currentPos, clobStr, 0, clobStr.length());
            this.currentPos += (long)b.length;
        }
        catch (SqlException ex) {
            IOException ioEx = new IOException();
            ioEx.initCause(ex);
            throw ioEx;
        }
    }
}

