/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.io;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Array;
import org.apache.derby.iapi.services.io.ArrayInputStream;
import org.apache.derby.iapi.services.io.ArrayUtil;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.sanity.SanityManager;

public class FormatableArrayHolder
implements Formatable {
    private Object[] array;

    public FormatableArrayHolder() {
    }

    public FormatableArrayHolder(Object[] array) {
        SanityManager.ASSERT(array != null, "array input to constructor is null, code can't handle this.");
        this.array = array;
    }

    public void setArray(Object[] array) {
        SanityManager.ASSERT(array != null, "array input to setArray() is null, code can't handle this.");
        this.array = array;
    }

    public Object[] getArray(Class inputClass) {
        Object[] outArray = (Object[])Array.newInstance(inputClass, this.array.length);
        for (int i = 0; i < outArray.length; ++i) {
            outArray[i] = this.array[i];
        }
        return outArray;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        SanityManager.ASSERT(this.array != null, "Array is null, which isn't expected");
        ArrayUtil.writeArrayLength(out, this.array);
        ArrayUtil.writeArrayItems(out, this.array);
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.array = new Object[ArrayUtil.readArrayLength(in)];
        ArrayUtil.readArrayItems(in, this.array);
    }

    public void readExternal(ArrayInputStream in) throws IOException, ClassNotFoundException {
        this.array = new Formatable[ArrayUtil.readArrayLength(in)];
        ArrayUtil.readArrayItems(in, this.array);
    }

    public int getTypeFormatId() {
        return 270;
    }
}

