/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.store.raw;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Hashtable;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.locks.Latch;
import org.apache.derby.iapi.services.locks.Lockable;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.store.raw.ContainerLock;
import org.apache.derby.iapi.store.raw.PageKey;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.util.Matchable;

public final class ContainerKey
implements Matchable,
Lockable {
    private final long segmentId;
    private final long containerId;

    public ContainerKey(long segmentId, long containerId) {
        this.segmentId = segmentId;
        this.containerId = containerId;
    }

    public long getContainerId() {
        return this.containerId;
    }

    public long getSegmentId() {
        return this.segmentId;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        CompressedNumber.writeLong(out, this.segmentId);
        CompressedNumber.writeLong(out, this.containerId);
    }

    public static ContainerKey read(ObjectInput in) throws IOException {
        long sid = CompressedNumber.readLong(in);
        long cid = CompressedNumber.readLong(in);
        return new ContainerKey(sid, cid);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof ContainerKey) {
            ContainerKey otherKey = (ContainerKey)other;
            return this.containerId == otherKey.containerId && this.segmentId == otherKey.segmentId;
        }
        return false;
    }

    public int hashCode() {
        return (int)(this.segmentId ^ this.containerId);
    }

    public String toString() {
        return "Container(" + this.segmentId + ", " + this.containerId + ")";
    }

    public boolean match(Object key) {
        if (this.equals(key)) {
            return true;
        }
        if (key instanceof PageKey) {
            return this.equals(((PageKey)key).getContainerId());
        }
        if (key instanceof RecordHandle) {
            return this.equals(((RecordHandle)key).getContainerId());
        }
        return false;
    }

    public void lockEvent(Latch lockInfo) {
    }

    public boolean requestCompatible(Object requestedQualifier, Object grantedQualifier) {
        SanityManager.ASSERT(requestedQualifier instanceof ContainerLock);
        SanityManager.ASSERT(grantedQualifier instanceof ContainerLock);
        ContainerLock clRequested = (ContainerLock)requestedQualifier;
        ContainerLock clGranted = (ContainerLock)grantedQualifier;
        return clRequested.isCompatible(clGranted);
    }

    public boolean lockerAlwaysCompatible() {
        return true;
    }

    public void unlockEvent(Latch lockInfo) {
    }

    public boolean lockAttributes(int flag, Hashtable attributes) {
        SanityManager.ASSERT(attributes != null, "cannot call lockProperties with null attribute list");
        if ((flag & 2) == 0) {
            return false;
        }
        attributes.put("CONTAINERID", new Long(this.getContainerId()));
        attributes.put("LOCKNAME", "Tablelock");
        attributes.put("TYPE", "TABLE");
        return true;
    }
}

