/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.derby.iapi.jdbc.EngineResultSet;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.impl.drda.ReEncodedInputStream;
import org.apache.derby.impl.jdbc.Util;

class EXTDTAInputStream
extends InputStream {
    private InputStream binaryInputStream = null;
    EngineResultSet rs;
    int columnNumber;
    int ndrdaType;

    private EXTDTAInputStream(ResultSet rs, int columnNumber, int ndrdaType) {
        this.rs = (EngineResultSet)rs;
        this.columnNumber = columnNumber;
        this.ndrdaType = ndrdaType;
    }

    public static EXTDTAInputStream getEXTDTAStream(ResultSet rs, int column, int drdaType) {
        int ndrdaType = drdaType | 1;
        return new EXTDTAInputStream(rs, column, ndrdaType);
    }

    public int read() throws IOException {
        return this.binaryInputStream.read();
    }

    public int available() throws IOException {
        return this.binaryInputStream.available();
    }

    public void close() throws IOException {
        if (this.binaryInputStream != null) {
            this.binaryInputStream.close();
        }
        this.binaryInputStream = null;
    }

    public boolean equals(Object arg0) {
        return this.binaryInputStream.equals(arg0);
    }

    public int hashCode() {
        return this.binaryInputStream.hashCode();
    }

    public void mark(int arg0) {
        this.binaryInputStream.mark(arg0);
    }

    public boolean markSupported() {
        return this.binaryInputStream.markSupported();
    }

    public int read(byte[] arg0) throws IOException {
        return this.binaryInputStream.read(arg0);
    }

    public int read(byte[] arg0, int arg1, int arg2) throws IOException {
        return this.binaryInputStream.read(arg0, arg1, arg2);
    }

    public void reset() throws IOException {
        this.binaryInputStream.reset();
    }

    public long skip(long arg0) throws IOException {
        if (arg0 < 0L) {
            return 0L;
        }
        return this.binaryInputStream.skip(arg0);
    }

    protected boolean isEmptyStream() throws SQLException {
        return this.rs.getLength(this.columnNumber) == 0;
    }

    public void initInputStream() throws SQLException {
        InputStream is = null;
        Reader r = null;
        if (this.ndrdaType == 201) {
            is = this.rs.getBinaryStream(this.columnNumber);
            if (is == null) {
                return;
            }
        } else if (this.ndrdaType == 207) {
            try {
                r = this.rs.getCharacterStream(this.columnNumber);
                if (r == null) {
                    return;
                }
                is = new ReEncodedInputStream(r);
            }
            catch (UnsupportedEncodingException e) {
                throw Util.javaException(e);
            }
            catch (IOException e) {
                throw Util.javaException(e);
            }
        } else {
            SanityManager.THROWASSERT("NDRDAType: " + this.ndrdaType + " not valid EXTDTA object type");
        }
        if (!is.markSupported()) {
            is = new BufferedInputStream(is);
        }
        this.binaryInputStream = is;
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public boolean isNull() throws SQLException {
        return this.rs.isNull(this.columnNumber);
    }
}

