/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.impl.io.BaseStorageFactory;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.StorageRandomAccessFile;

abstract class InputStreamFile
implements StorageFile {
    final String path;
    final int nameStart;
    final BaseStorageFactory storageFactory;

    InputStreamFile(BaseStorageFactory storageFactory, String path) {
        this.storageFactory = storageFactory;
        if (path == null || path.length() == 0) {
            this.path = storageFactory.dataDirectory;
            this.nameStart = -1;
        } else {
            StringBuffer sb = new StringBuffer(storageFactory.separatedDataDirectory);
            if (File.separatorChar != '/') {
                sb.append(path.replace(File.separatorChar, '/'));
            } else {
                sb.append(path);
            }
            this.path = sb.toString();
            this.nameStart = this.path.lastIndexOf(47) + 1;
        }
    }

    InputStreamFile(BaseStorageFactory storageFactory, String parent, String name) {
        this.storageFactory = storageFactory;
        StringBuffer sb = new StringBuffer(storageFactory.separatedDataDirectory);
        if (File.separatorChar != '/') {
            sb.append(parent.replace(File.separatorChar, '/'));
            sb.append('/');
            sb.append(name.replace(File.separatorChar, '/'));
        } else {
            sb.append(parent);
            sb.append('/');
            sb.append(name);
        }
        this.path = sb.toString();
        this.nameStart = this.path.lastIndexOf(47) + 1;
    }

    InputStreamFile(InputStreamFile dir, String name) {
        this.storageFactory = dir.storageFactory;
        StringBuffer sb = new StringBuffer(dir.path);
        sb.append('/');
        if (File.separatorChar != '/') {
            sb.append(name.replace(File.separatorChar, '/'));
        } else {
            sb.append(name);
        }
        this.path = sb.toString();
        this.nameStart = this.path.lastIndexOf(47) + 1;
    }

    InputStreamFile(BaseStorageFactory storageFactory, String child, int pathLen) {
        this.storageFactory = storageFactory;
        this.path = child.substring(0, pathLen);
        this.nameStart = this.path.lastIndexOf(47) + 1;
    }

    public boolean equals(Object other) {
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        InputStreamFile otherFile = (InputStreamFile)other;
        return this.path.equals(otherFile.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String[] list() {
        return null;
    }

    public boolean canWrite() {
        return false;
    }

    public abstract boolean exists();

    public boolean isDirectory() {
        return false;
    }

    public boolean delete() {
        return false;
    }

    public boolean deleteAll() {
        return false;
    }

    public String getPath() {
        if (File.separatorChar != '/') {
            return this.path.replace('/', File.separatorChar);
        }
        return this.path;
    }

    public String getCanonicalPath() throws IOException {
        return this.storageFactory.getCanonicalName() + "/" + this.path;
    }

    public String getName() {
        return this.nameStart < 0 ? "" : this.path.substring(this.nameStart);
    }

    public boolean createNewFile() throws IOException {
        throw new IOException("createNewFile called in a read-only file system.");
    }

    public boolean renameTo(StorageFile newName) {
        return false;
    }

    public boolean mkdir() {
        return false;
    }

    public boolean mkdirs() {
        return false;
    }

    public long length() {
        try {
            InputStream is = this.getInputStream();
            if (is == null) {
                return 0L;
            }
            long len = is.available();
            is.close();
            return len;
        }
        catch (IOException e) {
            return 0L;
        }
    }

    public StorageFile getParentDir() {
        if (this.path.length() <= this.storageFactory.separatedDataDirectory.length()) {
            return null;
        }
        return this.getParentDir(this.path.lastIndexOf(47));
    }

    abstract StorageFile getParentDir(int var1);

    public boolean setReadOnly() {
        return true;
    }

    public OutputStream getOutputStream() throws FileNotFoundException {
        throw new FileNotFoundException("Attempt to write into a read only file system.");
    }

    public OutputStream getOutputStream(boolean append) throws FileNotFoundException {
        throw new FileNotFoundException("Attempt to write into a read only file system.");
    }

    public abstract InputStream getInputStream() throws FileNotFoundException;

    public int getExclusiveFileLock() {
        return 0;
    }

    public void releaseExclusiveFileLock() {
    }

    public StorageRandomAccessFile getRandomAccessFile(String mode) throws FileNotFoundException {
        SanityManager.NOTREACHED();
        return null;
    }

    public String toString() {
        return this.path;
    }

    public URL getURL() throws MalformedURLException {
        throw new MalformedURLException(this.toString());
    }
}

