/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.io;

import java.io.IOException;
import org.apache.derby.impl.io.BaseStorageFactory;
import org.apache.derby.impl.io.URLFile;
import org.apache.derby.io.StorageFile;

public class URLStorageFactory
extends BaseStorageFactory {
    StorageFile newPersistentFile(String path) {
        return new URLFile(this, path);
    }

    StorageFile newPersistentFile(String directoryName, String fileName) {
        if (directoryName == null || directoryName.length() == 0) {
            return this.newPersistentFile(fileName);
        }
        return new URLFile(this, directoryName, fileName);
    }

    StorageFile newPersistentFile(StorageFile directoryName, String fileName) {
        if (directoryName == null) {
            return this.newPersistentFile(fileName);
        }
        return new URLFile((URLFile)directoryName, fileName);
    }

    void doInit() throws IOException {
        if (this.dataDirectory != null) {
            if (this.dataDirectory.endsWith("/")) {
                this.separatedDataDirectory = this.dataDirectory;
                this.dataDirectory = this.dataDirectory.substring(0, this.dataDirectory.length() - 1);
            } else {
                this.separatedDataDirectory = this.dataDirectory + '/';
            }
            this.canonicalName = this.dataDirectory;
            this.createTempDir();
        }
    }
}

