/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.impl.sql.compile.BinaryLogicalOperatorNode;
import org.apache.derby.impl.sql.compile.ExpressionClassBuilder;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

public class IsNode
extends BinaryLogicalOperatorNode {
    private boolean notMe;

    public void init(Object leftOperand, Object rightOperand, Object notMe) {
        super.init(leftOperand, rightOperand, "is");
        this.notMe = (Boolean)notMe;
    }

    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        super.bindExpression(fromList, subqueryList, aggregateVector);
        this.leftOperand.checkIsBoolean();
        this.rightOperand.checkIsBoolean();
        this.setType(this.leftOperand.getTypeServices());
        return this;
    }

    ValueNode eliminateNots(boolean underNotNode) throws StandardException {
        if (underNotNode) {
            this.notMe = !this.notMe;
        }
        this.leftOperand = this.leftOperand.eliminateNots(false);
        this.rightOperand = this.rightOperand.eliminateNots(false);
        return this;
    }

    public ValueNode putAndsOnTop() throws StandardException {
        this.leftOperand = this.leftOperand.putAndsOnTop();
        this.rightOperand = this.rightOperand.putAndsOnTop();
        return this;
    }

    public boolean verifyPutAndsOnTop() {
        return this.leftOperand.verifyPutAndsOnTop() && this.rightOperand.verifyPutAndsOnTop();
    }

    public ValueNode changeToCNF(boolean underTopAndNode) throws StandardException {
        this.leftOperand = this.leftOperand.changeToCNF(false);
        this.rightOperand = this.rightOperand.changeToCNF(false);
        return this;
    }

    public boolean verifyChangeToCNF() {
        return this.leftOperand.verifyChangeToCNF() && this.rightOperand.verifyChangeToCNF();
    }

    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        String evaluatorMethodName = this.notMe ? "isNot" : "is";
        this.leftOperand.generateExpression(acb, mb);
        this.rightOperand.generateExpression(acb, mb);
        mb.callMethod((short)185, "org.apache.derby.iapi.types.BooleanDataValue", evaluatorMethodName, "org.apache.derby.iapi.types.BooleanDataValue", 1);
    }
}

