/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.depend.DependencyManager;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptorList;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptorList;
import org.apache.derby.iapi.sql.dictionary.DataDescriptorGenerator;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.impl.sql.execute.ColumnInfo;
import org.apache.derby.impl.sql.execute.CreateConstraintConstantAction;
import org.apache.derby.impl.sql.execute.DDLConstantAction;
import org.apache.derby.impl.sql.execute.RowUtil;

class CreateTableConstantAction
extends DDLConstantAction {
    private char lockGranularity;
    private boolean onCommitDeleteRows;
    private boolean onRollbackDeleteRows;
    private String tableName;
    private String schemaName;
    private int tableType;
    private ColumnInfo[] columnInfo;
    private CreateConstraintConstantAction[] constraintActions;
    private Properties properties;

    CreateTableConstantAction(String schemaName, String tableName, int tableType, ColumnInfo[] columnInfo, CreateConstraintConstantAction[] constraintActions, Properties properties, char lockGranularity, boolean onCommitDeleteRows, boolean onRollbackDeleteRows) {
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.tableType = tableType;
        this.columnInfo = columnInfo;
        this.constraintActions = constraintActions;
        this.properties = properties;
        this.lockGranularity = lockGranularity;
        this.onCommitDeleteRows = onCommitDeleteRows;
        this.onRollbackDeleteRows = onRollbackDeleteRows;
        if (tableType == 0 && lockGranularity != 'T' && lockGranularity != 'R') {
            SanityManager.THROWASSERT("Unexpected value for lockGranularity = " + lockGranularity);
        }
        if (tableType == 3 && !onRollbackDeleteRows) {
            SanityManager.THROWASSERT("Unexpected value for onRollbackDeleteRows = " + onRollbackDeleteRows);
        }
        SanityManager.ASSERT(schemaName != null, "SchemaName is null");
    }

    public String toString() {
        if (this.tableType == 3) {
            return this.constructToString("DECLARE GLOBAL TEMPORARY TABLE ", this.tableName);
        }
        return this.constructToString("CREATE TABLE ", this.tableName);
    }

    public void executeConstantAction(Activation activation) throws StandardException {
        TableDescriptor td;
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        TransactionController tc = lcc.getTransactionExecute();
        activation.setForCreateTable();
        ExecRow template = RowUtil.getEmptyValueRow(this.columnInfo.length, lcc);
        int[] collation_ids = new int[this.columnInfo.length];
        for (int ix = 0; ix < this.columnInfo.length; ++ix) {
            ColumnInfo col_info = this.columnInfo[ix];
            if (col_info.defaultValue != null) {
                template.setColumn(ix + 1, col_info.defaultValue);
            } else {
                template.setColumn(ix + 1, col_info.dataType.getNull());
            }
            collation_ids[ix] = col_info.dataType.getCollationType();
        }
        long conglomId = tc.createConglomerate("heap", template.getRowArray(), null, collation_ids, this.properties, this.tableType == 3 ? 3 : 0);
        if (this.tableType != 3) {
            dd.startWriting(lcc);
        }
        SchemaDescriptor sd = this.tableType == 3 ? dd.getSchemaDescriptor(this.schemaName, tc, true) : DDLConstantAction.getSchemaDescriptorForCreate(dd, activation, this.schemaName);
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        if (this.tableType != 3) {
            td = ddg.newTableDescriptor(this.tableName, sd, this.tableType, this.lockGranularity);
            dd.addDescriptor(td, sd, 1, false, tc);
        } else {
            td = ddg.newTableDescriptor(this.tableName, sd, this.tableType, this.onCommitDeleteRows, this.onRollbackDeleteRows);
            td.setUUID(dd.getUUIDFactory().createUUID());
        }
        UUID toid = td.getUUID();
        activation.setDDLTableDescriptor(td);
        int index = 1;
        TupleDescriptor[] cdlArray = new ColumnDescriptor[this.columnInfo.length];
        for (int ix = 0; ix < this.columnInfo.length; ++ix) {
            UUID defaultUUID = this.columnInfo[ix].newDefaultUUID;
            if (this.columnInfo[ix].defaultInfo != null && defaultUUID == null) {
                defaultUUID = dd.getUUIDFactory().createUUID();
            }
            ColumnDescriptor columnDescriptor = this.columnInfo[ix].autoincInc != 0L ? new ColumnDescriptor(this.columnInfo[ix].name, index++, this.columnInfo[ix].dataType, this.columnInfo[ix].defaultValue, this.columnInfo[ix].defaultInfo, td, defaultUUID, this.columnInfo[ix].autoincStart, this.columnInfo[ix].autoincInc, this.columnInfo[ix].autoinc_create_or_modify_Start_Increment) : new ColumnDescriptor(this.columnInfo[ix].name, index++, this.columnInfo[ix].dataType, this.columnInfo[ix].defaultValue, this.columnInfo[ix].defaultInfo, td, defaultUUID, this.columnInfo[ix].autoincStart, this.columnInfo[ix].autoincInc);
            cdlArray[ix] = columnDescriptor;
        }
        if (this.tableType != 3) {
            dd.addDescriptorArray(cdlArray, td, 2, false, tc);
        }
        ColumnDescriptorList cdl = td.getColumnDescriptorList();
        for (int i = 0; i < cdlArray.length; ++i) {
            cdl.add(cdlArray[i]);
        }
        ConglomerateDescriptor cgd = ddg.newConglomerateDescriptor(conglomId, null, false, null, false, null, toid, sd.getUUID());
        if (this.tableType != 3) {
            dd.addDescriptor(cgd, sd, 0, false, tc);
        }
        ConglomerateDescriptorList conglomList = td.getConglomerateDescriptorList();
        conglomList.add(cgd);
        if (this.constraintActions != null) {
            int conIndex;
            for (conIndex = 0; conIndex < this.constraintActions.length; ++conIndex) {
                if (this.constraintActions[conIndex].isForeignKeyConstraint()) continue;
                this.constraintActions[conIndex].executeConstantAction(activation);
            }
            for (conIndex = 0; conIndex < this.constraintActions.length; ++conIndex) {
                if (!this.constraintActions[conIndex].isForeignKeyConstraint()) continue;
                this.constraintActions[conIndex].executeConstantAction(activation);
            }
        }
        for (int ix = 0; ix < this.columnInfo.length; ++ix) {
            this.addColumnDependencies(lcc, dd, td, this.columnInfo[ix]);
        }
        if (this.tableType == 3) {
            lcc.addDeclaredGlobalTempTable(td);
        }
    }
}

