/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.access.sort;

import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.store.access.conglomerate.TransactionManager;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.store.access.sort.MergeSort;
import org.apache.derby.impl.store.access.sort.Scan;

public abstract class SortScan
extends Scan {
    protected MergeSort sort = null;
    protected TransactionManager tran = null;
    protected DataValueDescriptor[] current;
    protected boolean hold;

    SortScan(MergeSort sort, TransactionManager tran, boolean hold) {
        this.sort = sort;
        this.tran = tran;
        this.hold = hold;
    }

    public final boolean fetchNext(DataValueDescriptor[] row) throws StandardException {
        boolean ret_val = this.next();
        if (ret_val) {
            this.fetch(row);
        }
        return ret_val;
    }

    public final void fetch(DataValueDescriptor[] result) throws StandardException {
        SanityManager.ASSERT(this.sort != null);
        if (this.current == null) {
            throw StandardException.newException("XSAS1.S");
        }
        this.sort.checkColumnTypes(result);
        System.arraycopy(this.current, 0, result, 0, result.length);
    }

    public final void fetchWithoutQualify(DataValueDescriptor[] result) throws StandardException {
        throw StandardException.newException("XSAS0.S");
    }

    public void close() {
        this.sort = null;
        this.current = null;
        this.tran.closeMe(this);
    }
}

