/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.tooling.btg.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.cosmos.me.sdd.resources.tooling.btg.Messages;
import org.eclipse.cosmos.me.sdd.tooling.btg.BTGLogUtil;
import org.eclipse.cosmos.me.sdd.tooling.btg.IBTGDataAggregator;
import org.eclipse.cosmos.me.sdd.tooling.btg.IBTGDataCollector;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BTGPlugin
extends Plugin {
    private static final String DATACOLLECTORS_EXTENSION_POINT = "org.eclipse.cosmos.me.sdd.tooling.btg.dataCollectors";
    private static final String DATAAGGREGATOR_EXTENSION_POINT = "org.eclipse.cosmos.me.sdd.tooling.btg.dataAggregator";
    private static BTGPlugin plugin;
    private static Logger logger;
    private static Logger consoleLogger;

    static {
        logger = Logger.getLogger("org.eclipse.cosmos.me.sdd.tooling.btg");
        consoleLogger = Logger.getLogger("org.eclipse.cosmos.me.sdd.tooling.btg.stdout");
    }

    public BTGPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static BTGPlugin getDefault() {
        return plugin;
    }

    public static Collection<IBTGDataCollector> getDataCollectorInstances() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint dataCollectorPoint = registry.getExtensionPoint(DATACOLLECTORS_EXTENSION_POINT);
        IExtension[] dataCollectorExtensions = dataCollectorPoint.getExtensions();
        if (dataCollectorExtensions.length == 0) {
            consoleLogger.info(Messages.getString("BTGPlugin.2"));
            return null;
        }
        ArrayList<IBTGDataCollector> pluginInstances = new ArrayList<IBTGDataCollector>();
        int i = 0;
        while (i < dataCollectorExtensions.length) {
            IExtension extension = dataCollectorExtensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            IConfigurationElement configurationElement = elements[0];
            try {
                pluginInstances.add((IBTGDataCollector)configurationElement.createExecutableExtension("class"));
            }
            catch (CoreException e) {
                consoleLogger.severe("CoreException");
                consoleLogger.log(Level.INFO, Messages.getString("BTGApplication.30"), BTGLogUtil.getMsgLogName());
                logger.log(Level.SEVERE, "ExceptionStack", e);
            }
            ++i;
        }
        return pluginInstances;
    }

    public static Collection<IBTGDataAggregator> getDataAggregatorInstances() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint dataAggregatorPoint = registry.getExtensionPoint(DATAAGGREGATOR_EXTENSION_POINT);
        IExtension[] dataAggregatorExtensions = dataAggregatorPoint.getExtensions();
        if (dataAggregatorExtensions.length == 0) {
            consoleLogger.info(Messages.getString("BTGPlugin.4"));
            return null;
        }
        ArrayList<IBTGDataAggregator> pluginInstances = new ArrayList<IBTGDataAggregator>();
        int i = 0;
        while (i < dataAggregatorExtensions.length) {
            IExtension extension = dataAggregatorExtensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            IConfigurationElement configurationElement = elements[0];
            try {
                pluginInstances.add((IBTGDataAggregator)configurationElement.createExecutableExtension("class"));
            }
            catch (CoreException e) {
                consoleLogger.severe("CoreException");
                consoleLogger.log(Level.INFO, Messages.getString("BTGApplication.30"), BTGLogUtil.getMsgLogName());
                logger.log(Level.SEVERE, "ExceptionStack", e);
            }
            ++i;
        }
        return pluginInstances;
    }

    public static String getDataCollectorPluginID(IBTGDataCollector dataCollector) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint dataCollectorPoint = registry.getExtensionPoint(DATACOLLECTORS_EXTENSION_POINT);
        IExtension[] dataCollectorExtensions = dataCollectorPoint.getExtensions();
        int i = 0;
        while (i < dataCollectorExtensions.length) {
            IExtension extension = dataCollectorExtensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            IConfigurationElement configurationElement = elements[0];
            try {
                Object dataCollectorInstance = configurationElement.createExecutableExtension("class");
                if (dataCollector.getClass() == dataCollectorInstance.getClass()) {
                    return extension.getContributor().getName();
                }
            }
            catch (CoreException e) {
                consoleLogger.severe("CoreException");
                consoleLogger.log(Level.INFO, Messages.getString("BTGApplication.30"), BTGLogUtil.getMsgLogName());
                logger.log(Level.SEVERE, "ExceptionStack", e);
            }
            ++i;
        }
        return null;
    }

    public static String getDataAggregatorPluginID(IBTGDataAggregator dataAggregator) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint dataAggregatorPoint = registry.getExtensionPoint(DATAAGGREGATOR_EXTENSION_POINT);
        IExtension[] dataAggregatorExtensions = dataAggregatorPoint.getExtensions();
        int i = 0;
        while (i < dataAggregatorExtensions.length) {
            IExtension extension = dataAggregatorExtensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            IConfigurationElement configurationElement = elements[0];
            try {
                Object dataAggregatorInstance = configurationElement.createExecutableExtension("class");
                if (dataAggregator.getClass() == dataAggregatorInstance.getClass()) {
                    return extension.getContributor().getName();
                }
            }
            catch (CoreException e) {
                consoleLogger.severe("CoreException");
                consoleLogger.log(Level.INFO, Messages.getString("BTGApplication.30"), BTGLogUtil.getMsgLogName());
                logger.log(Level.SEVERE, "ExceptionStack", e);
            }
            ++i;
        }
        return null;
    }
}

