/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.internal.dr.drs.service.outputter;

import java.io.PrintWriter;
import org.eclipse.cosmos.dc.provisional.cmdbf.query.client.QueryServiceClient;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.SaverHelper;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.XMLUtil;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.AbstractOutputter;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IOutputterContext;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IParameters;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CMDBfQuery
extends AbstractOutputter {
    public static final String CMDBF_QUERY = "query";
    public static final String MDREPR = "epr";
    public static final String QUERY_ID = "uuid";
    public static final String USERNAME = "username";
    public static final String PASSWORD = "password";
    public static final String SOAPVERSION = "soapversion";
    protected String rootDir;
    protected int limit = 0;

    public void initalize(IOutputterContext context, IParameters parameters) throws Exception {
        this.rootDir = context.getRealPath("queryRepository");
        String limitStr = context.getInitParameter("RESPONSE_HISTORY_LIMIT");
        if (limitStr != null) {
            try {
                this.limit = Integer.parseInt(limitStr);
            }
            catch (RuntimeException runtimeException) {
                this.limit = 0;
            }
        }
        super.initalize(context, parameters);
    }

    public void render(PrintWriter output, IParameters input) throws Exception {
        String query = input.getParameter(CMDBF_QUERY);
        String mdrEPR = input.getParameter(MDREPR);
        String uuid = input.getParameter(QUERY_ID);
        String username = input.getParameter(USERNAME);
        String password = input.getParameter(PASSWORD);
        String soapversion = input.getParameter(SOAPVERSION);
        if (mdrEPR != null && query != null) {
            Element response = this.submitQuery(mdrEPR, query, username, password, soapversion);
            String responseStr = XMLUtil.xmlToString(response);
            SaverHelper.saveResponse(responseStr, uuid, this.rootDir, this.limit);
            output.print(responseStr);
        }
    }

    protected Element submitQuery(String mdrEPR, String query, String username, String password, String soapversion) throws Exception {
        QueryServiceClient queryService = new QueryServiceClient(mdrEPR);
        if (username != null) {
            queryService.setUsername(username);
        }
        if (password != null) {
            queryService.setPassword(password);
        }
        if (soapversion != null) {
            queryService.setSoapVersion(Integer.parseInt(soapversion));
        }
        Document doc = XMLUtil.createDocument(query);
        Element elem = doc.getDocumentElement();
        return queryService.graphQuery(elem);
    }
}

