/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.test;

import java.util.List;
import org.eclipse.cosmos.dc.broker.provisional.client.BrokerClient;
import org.eclipse.cosmos.dc.broker.provisional.client.DataManager;
import org.eclipse.cosmos.dc.test.CommandEntry;
import org.eclipse.cosmos.dc.test.CosmosCLI;
import org.eclipse.cosmos.dc.test.Messages;
import org.eclipse.cosmos.dc.test.Tokenizer;

class CmdGetDataManagers
extends CommandEntry {
    CmdGetDataManagers(CosmosCLI cli) {
        this._cli = cli;
        this._command = new String("GetDataManagers");
        this._usage_entry = new String("USAGE_GETDMS_INFO");
    }

    public boolean validateArguments(Tokenizer st, String line) {
        String sns = null;
        if (st.hasMoreTokens()) {
            sns = st.nextToken();
            this._cli.setServiceNamespace(sns);
        }
        return true;
    }

    public void performAction() throws Exception {
        BrokerClient brokerclient = new BrokerClient(this._cli.getBrokerEPR());
        this._cli.logMessage(Messages.getString("DM_MESG_INFO"));
        List dmlist = null;
        dmlist = this._cli.getServiceNamespace() == null ? brokerclient.getDataManagers() : brokerclient.getDataManagerByNamespace(this._cli.getServiceNamespace());
        for (DataManager dm : dmlist) {
            this._cli.printDataManager(dm);
        }
    }
}

