/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.core;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.SimpleTimeZone;
import org.eclipse.hyades.internal.logging.core.internationalization.InternationalizationUtilities;
import org.eclipse.hyades.logging.core.LoggingCoreResourceBundle;

public class LoggingCoreUtilities {
    private static SimpleDateFormat xsdDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss", Locale.ENGLISH);
    private static Calendar cachedCalendar = new GregorianCalendar(new SimpleTimeZone(0, "UTC"), Locale.ENGLISH);
    private static final String DEFAULT_FORMATTED_DATE_FORMAT = "MMMM d, yyyy h:mm:ss.SSS a z";

    static {
        cachedCalendar.setLenient(false);
        GregorianCalendar xsdDateTimeFormatCalendar = new GregorianCalendar(new SimpleTimeZone(0, "UTC"), Locale.ENGLISH);
        xsdDateTimeFormatCalendar.setLenient(false);
        xsdDateTimeFormat.setLenient(false);
        xsdDateTimeFormat.setCalendar(xsdDateTimeFormatCalendar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long convertXsdDateTimeToMilliseconds(String xsdDateTime) {
        try {
            long millisecondTimeStamp = 0L;
            SimpleDateFormat simpleDateFormat = xsdDateTimeFormat;
            synchronized (simpleDateFormat) {
                millisecondTimeStamp = xsdDateTimeFormat.parse(xsdDateTime).getTime();
            }
            String optionalCharactersString = xsdDateTime.substring(xsdDateTime.indexOf(84) + 9).trim();
            int optionalCharactersStringLength = optionalCharactersString.length();
            if (optionalCharactersStringLength > 0) {
                int timeZoneStartIndex = optionalCharactersStringLength;
                if (InternationalizationUtilities.charAt(optionalCharactersString, optionalCharactersStringLength - 1) == 'Z') {
                    --timeZoneStartIndex;
                } else if (optionalCharactersStringLength >= 6) {
                    switch (InternationalizationUtilities.charAt(optionalCharactersString, optionalCharactersStringLength - 6)) {
                        case '+': {
                            millisecondTimeStamp -= Long.parseLong(optionalCharactersString.substring(optionalCharactersStringLength - 5, optionalCharactersStringLength - 3)) * 60L * 60L * 1000L + Long.parseLong(optionalCharactersString.substring(optionalCharactersStringLength - 2)) * 60L * 1000L;
                            timeZoneStartIndex = optionalCharactersStringLength - 6;
                            break;
                        }
                        case '-': {
                            millisecondTimeStamp += Long.parseLong(optionalCharactersString.substring(optionalCharactersStringLength - 5, optionalCharactersStringLength - 3)) * 60L * 60L * 1000L + Long.parseLong(optionalCharactersString.substring(optionalCharactersStringLength - 2)) * 60L * 1000L;
                            timeZoneStartIndex = optionalCharactersStringLength - 6;
                        }
                    }
                }
                if (timeZoneStartIndex != 0) {
                    if (InternationalizationUtilities.charAt(optionalCharactersString, 0) == '.' && Character.isDigit(InternationalizationUtilities.charAt(optionalCharactersString, 1))) {
                        switch (timeZoneStartIndex - 1) {
                            case 1: {
                                millisecondTimeStamp += Long.parseLong(optionalCharactersString.substring(1, timeZoneStartIndex)) * 100L;
                                break;
                            }
                            case 2: {
                                millisecondTimeStamp += Long.parseLong(optionalCharactersString.substring(1, timeZoneStartIndex)) * 10L;
                                break;
                            }
                            case 3: {
                                millisecondTimeStamp += Long.parseLong(optionalCharactersString.substring(1, timeZoneStartIndex));
                                break;
                            }
                            default: {
                                millisecondTimeStamp += Math.round((double)Long.parseLong(optionalCharactersString.substring(1, timeZoneStartIndex)) / Math.pow(10.0, timeZoneStartIndex - 4));
                                break;
                            }
                        }
                    } else {
                        throw new Exception();
                    }
                }
            }
            return millisecondTimeStamp;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(LoggingCoreResourceBundle.getString("LOG_INVALID_XSD_DATE_TIME_VALUE_EXC_", xsdDateTime));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertMillisecondsToXsdDateTime(long milliseconds) {
        Calendar calendar = cachedCalendar;
        synchronized (calendar) {
            cachedCalendar.setTimeInMillis(milliseconds);
            StringBuffer stringBuffer = new StringBuffer(24);
            int year = cachedCalendar.get(1);
            if (year < 10) {
                stringBuffer.append("000");
            } else if (year < 100) {
                stringBuffer.append("00");
            } else if (year < 1000) {
                stringBuffer.append("0");
            }
            stringBuffer.append(year);
            stringBuffer.append('-');
            int month = cachedCalendar.get(2) + 1;
            if (month < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(month);
            stringBuffer.append('-');
            int day = cachedCalendar.get(5);
            if (day < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(day);
            stringBuffer.append('T');
            int hour = cachedCalendar.get(11);
            if (hour < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(hour);
            stringBuffer.append(':');
            int minute = cachedCalendar.get(12);
            if (minute < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(minute);
            stringBuffer.append(':');
            int second = cachedCalendar.get(13);
            if (second < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(String.valueOf(second));
            stringBuffer.append('.');
            int millisecondValue = cachedCalendar.get(14);
            if (millisecondValue < 10) {
                stringBuffer.append("00");
            } else if (millisecondValue < 100) {
                stringBuffer.append('0');
            }
            stringBuffer.append(millisecondValue);
            stringBuffer.append('Z');
            return stringBuffer.toString();
        }
    }

    public static String getFormattedDateString(long milliseconds) throws IllegalArgumentException {
        return LoggingCoreUtilities.getFormattedDateString(milliseconds, DEFAULT_FORMATTED_DATE_FORMAT);
    }

    public static String getFormattedDateString(long milliseconds, String dateFormatPattern) throws IllegalArgumentException {
        return InternationalizationUtilities.format(milliseconds, dateFormatPattern, Locale.ENGLISH, "GMT");
    }

    public static String getFormattedDateString(String xsdDateTime) throws IllegalArgumentException {
        return LoggingCoreUtilities.getFormattedDateString(xsdDateTime, DEFAULT_FORMATTED_DATE_FORMAT);
    }

    public static String getFormattedDateString(String xsdDateTime, String dateFormatPattern) throws IllegalArgumentException {
        long utcMilliseconds = LoggingCoreUtilities.convertXsdDateTimeToMilliseconds(xsdDateTime);
        switch (InternationalizationUtilities.charAt(xsdDateTime.trim(), xsdDateTime.trim().length() - 6)) {
            case '+': 
            case '-': {
                return InternationalizationUtilities.format(utcMilliseconds, dateFormatPattern, Locale.ENGLISH, "GMT".concat(xsdDateTime.substring(xsdDateTime.trim().length() - 6).trim()));
            }
        }
        return InternationalizationUtilities.format(utcMilliseconds, dateFormatPattern, Locale.ENGLISH, "GMT");
    }
}

