/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.sql.SQLException;
import java.util.StringTokenizer;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.PreparedStatement;
import org.apache.derby.client.am.ProductLevel;
import org.apache.derby.client.am.ResultSet;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.Version;

public abstract class DatabaseMetaData
implements java.sql.DatabaseMetaData {
    private static final short SQL_BEST_ROWID = 1;
    private static final short SQL_ROWVER = 2;
    private static final short SQL_INDEX_UNIQUE = 0;
    private static final short SQL_INDEX_ALL = 1;
    protected Agent agent_;
    protected Connection connection_;
    private static final int numberOfMetaDataInfoMethods__ = 108;
    private Object[] metaDataInfoCache_ = new Object[108];
    private boolean metaDataInfoIsCached_ = false;
    public ProductLevel productLevel_;
    private final int serverJdbcMajorVersion;
    private final int serverJdbcMinorVersion;
    public boolean useServerXAState_ = true;
    private static final int allProceduresAreCallable__ = 0;
    private static final int allTablesAreSelectable__ = 1;
    private static final int nullsAreSortedHigh__ = 2;
    private static final int nullsAreSortedLow__ = 3;
    private static final int nullsAreSortedAtStart__ = 4;
    private static final int nullsAreSortedAtEnd__ = 5;
    private static final int usesLocalFiles__ = 6;
    private static final int usesLocalFilePerTable__ = 7;
    private static final int storesUpperCaseIdentifiers__ = 8;
    private static final int storesLowerCaseIdentifiers__ = 9;
    private static final int storesMixedCaseIdentifiers__ = 10;
    private static final int storesUpperCaseQuotedIdentifiers__ = 11;
    private static final int storesLowerCaseQuotedIdentifiers__ = 12;
    private static final int storesMixedCaseQuotedIdentifiers__ = 13;
    private static final int getSQLKeywords__ = 14;
    private static final int getNumericFunctions__ = 15;
    private static final int getStringFunctions__ = 16;
    private static final int getSystemFunctions__ = 17;
    private static final int getTimeDateFunctions__ = 18;
    private static final int getSearchStringEscape__ = 19;
    private static final int getExtraNameCharacters__ = 20;
    private static final int supportsAlterTableWithAddColumn__ = 21;
    private static final int supportsAlterTableWithDropColumn__ = 22;
    private static final int supportsConvert__ = 23;
    private static final int supportsConvertType__ = 24;
    private static final int supportsDifferentTableCorrelationNames__ = 25;
    private static final int supportsExpressionsInOrderBy__ = 26;
    private static final int supportsOrderByUnrelated__ = 27;
    private static final int supportsGroupBy__ = 28;
    private static final int supportsGroupByUnrelated__ = 29;
    private static final int supportsGroupByBeyondSelect__ = 30;
    private static final int supportsMultipleResultSets__ = 31;
    private static final int supportsMultipleTransactions__ = 32;
    private static final int supportsCoreSQLGrammar__ = 33;
    private static final int supportsExtendedSQLGrammar__ = 34;
    private static final int supportsANSI92IntermediateSQL__ = 35;
    private static final int supportsANSI92FullSQL__ = 36;
    private static final int supportsIntegrityEnhancementFacility__ = 37;
    private static final int supportsOuterJoins__ = 38;
    private static final int supportsFullOuterJoins__ = 39;
    private static final int supportsLimitedOuterJoins__ = 40;
    private static final int getSchemaTerm__ = 41;
    private static final int getProcedureTerm__ = 42;
    private static final int getCatalogTerm__ = 43;
    private static final int isCatalogAtStart__ = 44;
    private static final int getCatalogSeparator__ = 45;
    private static final int supportsSchemasInDataManipulation__ = 46;
    private static final int supportsSchemasInProcedureCalls__ = 47;
    private static final int supportsSchemasInTableDefinitions__ = 48;
    private static final int supportsSchemasInIndexDefinitions__ = 49;
    private static final int supportsSchemasInPrivilegeDefinitions__ = 50;
    private static final int supportsCatalogsInDataManipulation__ = 51;
    private static final int supportsCatalogsInProcedureCalls__ = 52;
    private static final int supportsCatalogsInTableDefinitions__ = 53;
    private static final int supportsCatalogsInIndexDefinitions__ = 54;
    private static final int supportsCatalogsInPrivilegeDefinitions__ = 55;
    private static final int supportsPositionedDelete__ = 56;
    private static final int supportsPositionedUpdate__ = 57;
    private static final int supportsSelectForUpdate__ = 58;
    private static final int supportsStoredProcedures__ = 59;
    private static final int supportsSubqueriesInComparisons__ = 60;
    private static final int supportsUnion__ = 61;
    private static final int supportsUnionAll__ = 62;
    private static final int supportsOpenCursorsAcrossCommit__ = 63;
    private static final int supportsOpenCursorsAcrossRollback__ = 64;
    private static final int supportsOpenStatementsAcrossCommit__ = 65;
    private static final int supportsOpenStatementsAcrossRollback__ = 66;
    private static final int getMaxBinaryLiteralLength__ = 67;
    private static final int getMaxCharLiteralLength__ = 68;
    private static final int getMaxColumnNameLength__ = 69;
    private static final int getMaxColumnsInGroupBy__ = 70;
    private static final int getMaxColumnsInIndex__ = 71;
    private static final int getMaxColumnsInOrderBy__ = 72;
    private static final int getMaxColumnsInSelect__ = 73;
    private static final int getMaxColumnsInTable__ = 74;
    private static final int getMaxConnections__ = 75;
    private static final int getMaxCursorNameLength__ = 76;
    private static final int getMaxIndexLength__ = 77;
    private static final int getMaxSchemaNameLength__ = 78;
    private static final int getMaxProcedureNameLength__ = 79;
    private static final int getMaxCatalogNameLength__ = 80;
    private static final int getMaxRowSize__ = 81;
    private static final int doesMaxRowSizeIncludeBlobs__ = 82;
    private static final int getMaxStatementLength__ = 83;
    private static final int getMaxStatements__ = 84;
    private static final int getMaxTableNameLength__ = 85;
    private static final int getMaxTablesInSelect__ = 86;
    private static final int getMaxUserNameLength__ = 87;
    private static final int getDefaultTransactionIsolation__ = 88;
    private static final int supportsTransactions__ = 89;
    private static final int supportsTransactionIsolationLevel__ = 90;
    private static final int supportsDataDefinitionAndDataManipulationTransactions__ = 91;
    private static final int supportsDataManipulationTransactionsOnly__ = 92;
    private static final int dataDefinitionCausesTransactionCommit__ = 93;
    private static final int dataDefinitionIgnoredInTransactions__ = 94;
    private static final int supportsResultSetType__ = 95;
    private static final int supportsResultSetConcurrency__ = 96;
    private static final int ownUpdatesAreVisible__ = 97;
    private static final int ownDeletesAreVisible__ = 98;
    private static final int ownInsertsAreVisible__ = 99;
    private static final int othersUpdatesAreVisible__ = 100;
    private static final int othersDeletesAreVisible__ = 101;
    private static final int othersInsertsAreVisible__ = 102;
    private static final int updatesAreDetected__ = 103;
    private static final int deletesAreDetected__ = 104;
    private static final int insertsAreDetected__ = 105;
    private static final int supportsBatchUpdates__ = 106;

    protected DatabaseMetaData(Agent agent, Connection connection, ProductLevel productLevel) {
        this.agent_ = agent;
        this.connection_ = connection;
        this.productLevel_ = productLevel;
        this.computeFeatureSet_();
        if (connection.isXAConnection()) {
            connection.xaHostVersion_ = this.productLevel_.versionLevel_;
        }
        if (this.productLevel_.lessThan(10, 2, 0)) {
            this.serverJdbcMajorVersion = 3;
            this.serverJdbcMinorVersion = 0;
        } else {
            this.serverJdbcMajorVersion = 4;
            this.serverJdbcMinorVersion = 0;
        }
    }

    public boolean allProceduresAreCallable() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(0);
    }

    public boolean allTablesAreSelectable() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(1);
    }

    public boolean nullsAreSortedHigh() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(2);
    }

    public boolean nullsAreSortedLow() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(3);
    }

    public boolean nullsAreSortedAtStart() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(4);
    }

    public boolean nullsAreSortedAtEnd() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(5);
    }

    public boolean usesLocalFiles() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(6);
    }

    public boolean usesLocalFilePerTable() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(7);
    }

    public boolean storesUpperCaseIdentifiers() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(8);
    }

    public boolean storesLowerCaseIdentifiers() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(9);
    }

    public boolean storesMixedCaseIdentifiers() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(10);
    }

    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(11);
    }

    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(12);
    }

    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(13);
    }

    public String getSQLKeywords() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoString(14);
    }

    public String getNumericFunctions() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoString(15);
    }

    public String getStringFunctions() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoString(16);
    }

    public String getSystemFunctions() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoString(17);
    }

    public String getTimeDateFunctions() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoString(18);
    }

    public String getSearchStringEscape() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoString(19);
    }

    public String getExtraNameCharacters() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoString(20);
    }

    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(21);
    }

    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(22);
    }

    public boolean supportsConvert() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(23);
    }

    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean_supportsConvert(24, fromType, toType);
    }

    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(25);
    }

    public boolean supportsExpressionsInOrderBy() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(26);
    }

    public boolean supportsOrderByUnrelated() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(27);
    }

    public boolean supportsGroupBy() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(28);
    }

    public boolean supportsGroupByUnrelated() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(29);
    }

    public boolean supportsGroupByBeyondSelect() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(30);
    }

    public boolean supportsMultipleResultSets() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(31);
    }

    public boolean supportsMultipleTransactions() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(32);
    }

    public boolean supportsCoreSQLGrammar() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(33);
    }

    public boolean supportsExtendedSQLGrammar() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(34);
    }

    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(35);
    }

    public boolean supportsANSI92FullSQL() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(36);
    }

    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(37);
    }

    public boolean supportsOuterJoins() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(38);
    }

    public boolean supportsFullOuterJoins() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(39);
    }

    public boolean supportsLimitedOuterJoins() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(40);
    }

    public String getSchemaTerm() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoString(41);
    }

    public String getProcedureTerm() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoString(42);
    }

    public String getCatalogTerm() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoString(43);
    }

    public boolean isCatalogAtStart() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(44);
    }

    public String getCatalogSeparator() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoString(45);
    }

    public boolean supportsSchemasInDataManipulation() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(46);
    }

    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(47);
    }

    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(48);
    }

    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(49);
    }

    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(50);
    }

    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(51);
    }

    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(52);
    }

    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(53);
    }

    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(54);
    }

    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(55);
    }

    public boolean supportsPositionedDelete() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(56);
    }

    public boolean supportsPositionedUpdate() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(57);
    }

    public boolean supportsSelectForUpdate() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(58);
    }

    public boolean supportsStoredProcedures() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(59);
    }

    public boolean supportsSubqueriesInComparisons() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(60);
    }

    public boolean supportsUnion() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(61);
    }

    public boolean supportsUnionAll() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(62);
    }

    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(63);
    }

    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(64);
    }

    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(65);
    }

    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(66);
    }

    public int getMaxBinaryLiteralLength() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(67);
    }

    public int getMaxCharLiteralLength() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(68);
    }

    public int getMaxColumnNameLength() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(69);
    }

    public int getMaxColumnsInGroupBy() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(70);
    }

    public int getMaxColumnsInIndex() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(71);
    }

    public int getMaxColumnsInOrderBy() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(72);
    }

    public int getMaxColumnsInSelect() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(73);
    }

    public int getMaxColumnsInTable() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(74);
    }

    public int getMaxConnections() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(75);
    }

    public int getMaxCursorNameLength() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(76);
    }

    public int getMaxIndexLength() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(77);
    }

    public int getMaxSchemaNameLength() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(78);
    }

    public int getMaxProcedureNameLength() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(79);
    }

    public int getMaxCatalogNameLength() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(80);
    }

    public int getMaxRowSize() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(81);
    }

    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(82);
    }

    public int getMaxStatementLength() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(83);
    }

    public int getMaxStatements() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(84);
    }

    public int getMaxTableNameLength() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(85);
    }

    public int getMaxTablesInSelect() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(86);
    }

    public int getMaxUserNameLength() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(87);
    }

    public int getDefaultTransactionIsolation() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt(88);
    }

    public boolean supportsTransactions() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(89);
    }

    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBooleanWithType(90, level);
    }

    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(91);
    }

    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(92);
    }

    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(93);
    }

    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(94);
    }

    public boolean supportsResultSetType(int type) throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBooleanWithType(95, type);
    }

    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoInt_SupportsResultSetConcurrency(96, type, concurrency);
    }

    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBooleanWithType(97, type);
    }

    public boolean ownDeletesAreVisible(int type) throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBooleanWithType(98, type);
    }

    public boolean ownInsertsAreVisible(int type) throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBooleanWithType(99, type);
    }

    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBooleanWithType(100, type);
    }

    public boolean othersDeletesAreVisible(int type) throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBooleanWithType(101, type);
    }

    public boolean othersInsertsAreVisible(int type) throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBooleanWithType(102, type);
    }

    public boolean updatesAreDetected(int type) throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBooleanWithType(103, type);
    }

    public boolean deletesAreDetected(int type) throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBooleanWithType(104, type);
    }

    public boolean insertsAreDetected(int type) throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBooleanWithType(105, type);
    }

    public boolean supportsBatchUpdates() throws SQLException {
        this.checkForClosedConnection();
        return this.getMetaDataInfoBoolean(106);
    }

    public boolean supportsSavepoints() throws SQLException {
        this.checkForClosedConnection();
        return this.productLevel_.greaterThanOrEqualTo(5, 2, 0);
    }

    public abstract String getURL_() throws SqlException;

    public String getURL() throws SQLException {
        try {
            this.checkForClosedConnection();
            return this.getURL_();
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public String getUserName() throws SQLException {
        this.checkForClosedConnection();
        return this.connection_.user_;
    }

    public boolean isReadOnly() throws SQLException {
        return false;
    }

    public String getDatabaseProductName() throws SQLException {
        this.checkForClosedConnection();
        return this.productLevel_.databaseProductName_;
    }

    public String getDatabaseProductVersion() throws SQLException {
        this.checkForClosedConnection();
        return this.productLevel_.databaseProductVersion_;
    }

    public String getDriverName() throws SQLException {
        this.checkForClosedConnection();
        return "Apache Derby Network Client JDBC Driver";
    }

    public String getDriverVersion() throws SQLException {
        this.checkForClosedConnection();
        return Version.getDriverVersion();
    }

    public int getDriverMajorVersion() {
        return Version.getMajorVersion();
    }

    public int getDriverMinorVersion() {
        return Version.getMinorVersion();
    }

    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public String getIdentifierQuoteString() throws SQLException {
        this.checkForClosedConnection();
        return "\"";
    }

    public boolean supportsColumnAliasing() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean nullPlusNonNullIsNull() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsTableCorrelationNames() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsLikeEscapeClause() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsNonNullableColumns() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsMinimumSQLGrammar() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsSubqueriesInExists() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsSubqueriesInIns() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsCorrelatedSubqueries() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getProcedures", (Object)catalog, (Object)schemaPattern, (Object)procedureNamePattern);
                }
                return this.getProceduresX(catalog, schemaPattern, procedureNamePattern);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ResultSet getProceduresX(String catalog, String schemaPattern, String procedureNamePattern) throws SqlException {
        this.checkForClosedConnectionX();
        PreparedStatement cs = this.prepareMetaDataQuery("SYSIBM.SQLPROCEDURES(?,?,?,?)");
        cs.setStringX(1, catalog);
        cs.setStringX(2, schemaPattern);
        cs.setStringX(3, procedureNamePattern);
        cs.setStringX(4, this.getOptions());
        return this.executeCatalogQuery(cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getProcedureColumns", (Object)catalog, (Object)schemaPattern, (Object)procedureNamePattern, (Object)columnNamePattern);
                }
                return this.getProcedureColumnsX(catalog, schemaPattern, procedureNamePattern, columnNamePattern);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ResultSet getProcedureColumnsX(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SqlException {
        this.checkForClosedConnectionX();
        PreparedStatement cs = this.prepareMetaDataQuery("SYSIBM.SQLPROCEDURECOLS(?,?,?,?,?)");
        cs.setStringX(1, catalog);
        cs.setStringX(2, schemaPattern);
        cs.setStringX(3, procedureNamePattern);
        cs.setStringX(4, columnNamePattern);
        cs.setStringX(5, this.getOptions());
        return this.executeCatalogQuery(cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getFunctions", (Object)catalog, (Object)schemaPattern, (Object)functionNamePattern);
                }
                return this.getFunctionsX(catalog, schemaPattern, functionNamePattern);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ResultSet getFunctionsX(String catalog, String schemaPattern, String functionNamePattern) throws SqlException {
        this.checkForClosedConnectionX();
        this.checkServerJdbcVersionX("getFunctions(String,String,String)", 4, 0);
        PreparedStatement cs = this.prepareMetaDataQuery("SYSIBM.SQLFUNCTIONS(?,?,?,?)");
        cs.setStringX(1, catalog);
        cs.setStringX(2, schemaPattern);
        cs.setStringX(3, functionNamePattern);
        cs.setStringX(4, this.getOptions());
        return this.executeCatalogQuery(cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getFunctionColumns(String catalog, String schemaPattern, String functionNamePattern, String parameterNamePattern) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getFunctionColumns", (Object)catalog, (Object)schemaPattern, (Object)functionNamePattern, (Object)parameterNamePattern);
                }
                return this.getFunctionColumnsX(catalog, schemaPattern, functionNamePattern, parameterNamePattern);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ResultSet getFunctionColumnsX(String catalog, String schemaPattern, String functionNamePattern, String parameterNamePattern) throws SqlException {
        this.checkForClosedConnectionX();
        this.checkServerJdbcVersionX("getFunctionColumns(String,String,String,String)", 4, 0);
        PreparedStatement cs = this.prepareMetaDataQuery("SYSIBM.SQLFUNCTIONPARAMS(?,?,?,?,?)");
        cs.setStringX(1, catalog);
        cs.setStringX(2, schemaPattern);
        cs.setStringX(3, functionNamePattern);
        cs.setStringX(4, parameterNamePattern);
        cs.setStringX(5, this.getOptions());
        return this.executeCatalogQuery(cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getTables", (Object)catalog, (Object)schemaPattern, (Object)tableNamePattern, (Object)types);
                }
                return this.getTablesX(catalog, schemaPattern, tableNamePattern, types);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ResultSet getTablesX(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SqlException {
        try {
            this.checkForClosedConnection();
        }
        catch (SQLException se) {
            throw new SqlException(se);
        }
        PreparedStatement cs = this.prepareMetaDataQuery("SYSIBM.SQLTABLES(?,?,?,?,?)");
        if (catalog == null) {
            cs.setNullX(1, 12);
        } else {
            cs.setStringX(1, catalog);
        }
        if (schemaPattern == null) {
            cs.setNullX(2, 12);
        } else {
            cs.setStringX(2, schemaPattern);
        }
        if (tableNamePattern == null) {
            cs.setNullX(3, 12);
        } else {
            cs.setStringX(3, tableNamePattern);
        }
        String tableTypes = new String();
        if (types == null) {
            cs.setNullX(4, 12);
        } else if (types.length == 1 && types[0].trim().equals("%")) {
            cs.setStringX(4, types[0]);
        } else {
            for (int i = 0; i < types.length; ++i) {
                if (i > 0) {
                    tableTypes = tableTypes.concat(",");
                }
                tableTypes = tableTypes.concat("'" + types[i] + "'");
            }
            cs.setStringX(4, tableTypes);
        }
        cs.setStringX(5, this.getOptions());
        return this.executeCatalogQuery(cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getSchemas() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getSchemas");
                }
                return this.getSchemasX();
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ResultSet getSchemasX() throws SqlException {
        try {
            this.checkForClosedConnection();
        }
        catch (SQLException se) {
            throw new SqlException(se);
        }
        PreparedStatement cs = this.prepareMetaDataQuery("SYSIBM.SQLTABLES('', '', '', '', 'GETSCHEMAS=1')");
        return cs.executeQueryX();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getCatalogs() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getCatalogs");
                }
                return this.getCatalogsX();
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ResultSet getCatalogsX() throws SqlException {
        this.checkForClosedConnectionX();
        PreparedStatement cs = this.prepareMetaDataQuery("SYSIBM.SQLTABLES('', '', '', '', 'GETCATALOGS=1')");
        return cs.executeQueryX();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getTableTypes() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getTableTypes");
                }
                return this.getTableTypesX();
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ResultSet getTableTypesX() throws SqlException {
        this.checkForClosedConnectionX();
        PreparedStatement cs = null;
        cs = this.prepareMetaDataQuery("SYSIBM.SQLTABLES(?,?,?,?,?)");
        cs.setStringX(1, "");
        cs.setStringX(2, "");
        cs.setStringX(3, "");
        cs.setStringX(4, "%");
        int cursorHold = this.connection_.holdability() == 1 ? 1 : 0;
        cs.setStringX(5, "DATATYPE='JDBC';GETTABLETYPES=1; CURSORHOLD=" + cursorHold);
        return this.executeCatalogQuery(cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getColumns", (Object)catalog, (Object)schemaPattern, (Object)tableNamePattern, (Object)columnNamePattern);
                }
                this.checkForClosedConnection();
                return this.getColumnsX(catalog, schemaPattern, tableNamePattern, columnNamePattern);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ResultSet getColumnsX(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SqlException {
        this.checkForClosedConnectionX();
        PreparedStatement cs = this.prepareMetaDataQuery("SYSIBM.SQLCOLUMNS(?,?,?,?,?)");
        cs.setStringX(1, catalog);
        cs.setStringX(2, schemaPattern);
        cs.setStringX(3, tableNamePattern);
        cs.setStringX(4, columnNamePattern);
        cs.setStringX(5, this.getOptions());
        return this.executeCatalogQuery(cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getColumnPrivileges", (Object)catalog, (Object)schema, (Object)table, (Object)columnNamePattern);
                }
                return this.getColumnPrivilegesX(catalog, schema, table, columnNamePattern);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ResultSet getColumnPrivilegesX(String catalog, String schema, String table, String columnNamePattern) throws SqlException {
        this.checkForClosedConnectionX();
        if (table == null) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ103.S"));
        }
        PreparedStatement cs = this.prepareMetaDataQuery("SYSIBM.SQLCOLPRIVILEGES(?,?,?,?,?)");
        cs.setStringX(1, catalog);
        cs.setStringX(2, schema);
        cs.setStringX(3, table);
        cs.setStringX(4, columnNamePattern);
        cs.setStringX(5, this.getOptions());
        return this.executeCatalogQuery(cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getTablePrivileges", (Object)catalog, (Object)schemaPattern, (Object)tableNamePattern);
                }
                return this.getTablePrivilegesX(catalog, schemaPattern, tableNamePattern);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ResultSet getTablePrivilegesX(String catalog, String schemaPattern, String tableNamePattern) throws SqlException {
        this.checkForClosedConnectionX();
        PreparedStatement cs = this.prepareMetaDataQuery("SYSIBM.SQLTABLEPRIVILEGES(?,?,?,?)");
        cs.setStringX(1, catalog);
        cs.setStringX(2, schemaPattern);
        cs.setStringX(3, tableNamePattern);
        cs.setStringX(4, this.getOptions());
        return this.executeCatalogQuery(cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getBestRowIdentifier", (Object)catalog, (Object)schema, (Object)table, scope, nullable);
                }
                return this.getBestRowIdentifierX(catalog, schema, table, scope, nullable);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ResultSet getBestRowIdentifierX(String catalog, String schema, String table, int scope, boolean nullable) throws SqlException {
        this.checkForClosedConnectionX();
        if (table == null) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ103.S"));
        }
        PreparedStatement cs = this.prepareMetaDataQuery("SYSIBM.SQLSPECIALCOLUMNS(?,?,?,?,?,?,?)");
        cs.setIntX(1, 1);
        cs.setStringX(2, catalog);
        cs.setStringX(3, schema);
        cs.setStringX(4, table);
        cs.setIntX(5, scope);
        if (nullable) {
            cs.setShortX(6, (short)1);
        } else {
            cs.setShortX(6, (short)0);
        }
        cs.setStringX(7, this.getOptions());
        return this.executeCatalogQuery(cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getVersionColumns", (Object)catalog, (Object)schema, (Object)table);
                }
                return this.getVersionColumnsX(catalog, schema, table);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ResultSet getVersionColumnsX(String catalog, String schema, String table) throws SqlException {
        this.checkForClosedConnectionX();
        if (table == null) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ103.S"));
        }
        PreparedStatement cs = this.prepareMetaDataQuery("SYSIBM.SQLSPECIALCOLUMNS(?,?,?,?,?,?,?)");
        cs.setIntX(1, 2);
        cs.setStringX(2, catalog);
        cs.setStringX(3, schema);
        cs.setStringX(4, table);
        cs.setIntX(5, 0);
        cs.setShortX(6, (short)0);
        cs.setStringX(7, this.getOptions());
        return this.executeCatalogQuery(cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getPrimaryKeys", (Object)catalog, (Object)schema, (Object)table);
                }
                return this.getPrimaryKeysX(catalog, schema, table);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ResultSet getPrimaryKeysX(String catalog, String schema, String table) throws SqlException {
        this.checkForClosedConnectionX();
        if (table == null) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ103.S"));
        }
        PreparedStatement cs = this.prepareMetaDataQuery("SYSIBM.SQLPRIMARYKEYS(?,?,?,?)");
        cs.setStringX(1, catalog);
        cs.setStringX(2, schema);
        cs.setStringX(3, table);
        cs.setStringX(4, this.getOptions());
        return this.executeCatalogQuery(cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getImportedKeys", (Object)catalog, (Object)schema, (Object)table);
                }
                return this.getImportedKeysX(catalog, schema, table);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ResultSet getImportedKeysX(String catalog, String schema, String table) throws SqlException {
        this.checkForClosedConnectionX();
        if (table == null) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ103.S"));
        }
        PreparedStatement cs = this.prepareMetaDataQuery("SYSIBM.SQLFOREIGNKEYS(?,?,?,?,?,?,?)");
        cs.setStringX(1, "");
        cs.setStringX(2, null);
        cs.setStringX(3, "");
        cs.setStringX(4, catalog);
        cs.setStringX(5, schema);
        cs.setStringX(6, table);
        if (this.connection_.holdability() == 1) {
            cs.setStringX(7, "DATATYPE='JDBC';IMPORTEDKEY=1; CURSORHOLD=1");
        } else {
            cs.setStringX(7, "DATATYPE='JDBC';IMPORTEDKEY=1; CURSORHOLD=0");
        }
        return this.executeCatalogQuery(cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getExportedKeys", (Object)catalog, (Object)schema, (Object)table);
                }
                return this.getExportedKeysX(catalog, schema, table);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ResultSet getExportedKeysX(String catalog, String schema, String table) throws SqlException {
        this.checkForClosedConnectionX();
        if (table == null) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ103.S"));
        }
        PreparedStatement cs = this.prepareMetaDataQuery("SYSIBM.SQLFOREIGNKEYS(?,?,?,?,?,?,?)");
        cs.setStringX(1, catalog);
        cs.setStringX(2, schema);
        cs.setStringX(3, table);
        cs.setStringX(4, "");
        cs.setStringX(5, null);
        cs.setStringX(6, "");
        if (this.connection_.holdability() == 1) {
            cs.setStringX(7, "DATATYPE='JDBC';EXPORTEDKEY=1; CURSORHOLD=1");
        } else {
            cs.setStringX(7, "DATATYPE='JDBC';EXPORTEDKEY=1; CURSORHOLD=0");
        }
        return this.executeCatalogQuery(cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getCrossReference", primaryCatalog, primarySchema, primaryTable, foreignCatalog, foreignSchema, foreignTable);
                }
                return this.getCrossReferenceX(primaryCatalog, primarySchema, primaryTable, foreignCatalog, foreignSchema, foreignTable);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ResultSet getCrossReferenceX(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SqlException {
        this.checkForClosedConnectionX();
        if (primaryTable == null) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ110.S"));
        }
        if (foreignTable == null) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ111.S"));
        }
        PreparedStatement cs = this.prepareMetaDataQuery("SYSIBM.SQLFOREIGNKEYS(?,?,?,?,?,?,?)");
        cs.setStringX(1, primaryCatalog);
        cs.setStringX(2, primarySchema);
        cs.setStringX(3, primaryTable);
        cs.setStringX(4, foreignCatalog);
        cs.setStringX(5, foreignSchema);
        cs.setStringX(6, foreignTable);
        cs.setStringX(7, this.getOptions());
        return this.executeCatalogQuery(cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getTypeInfo() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getTypeInfo");
                }
                return this.getTypeInfoX();
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ResultSet getTypeInfoX() throws SqlException {
        this.checkForClosedConnectionX();
        PreparedStatement cs = this.prepareMetaDataQuery("SYSIBM.SQLGETTYPEINFO(?,?)");
        cs.setShortX(1, (short)0);
        cs.setStringX(2, this.getOptions());
        return this.executeCatalogQuery(cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getIndexInfo", (Object)catalog, (Object)schema, (Object)table, unique, approximate);
                }
                return this.getIndexInfoX(catalog, schema, table, unique, approximate);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ResultSet getIndexInfoX(String catalog, String schema, String table, boolean unique, boolean approximate) throws SqlException {
        this.checkForClosedConnectionX();
        if (table == null) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ103.S"));
        }
        PreparedStatement cs = this.prepareMetaDataQuery("SYSIBM.SQLSTATISTICS(?,?,?,?,?,?)");
        cs.setStringX(1, catalog);
        cs.setStringX(2, schema);
        cs.setStringX(3, table);
        if (unique) {
            cs.setShortX(4, (short)0);
        } else {
            cs.setShortX(4, (short)1);
        }
        if (approximate) {
            cs.setShortX(5, (short)1);
        } else {
            cs.setShortX(5, (short)0);
        }
        cs.setStringX(6, this.getOptions());
        return this.executeCatalogQuery(cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getUDTs", (Object)catalog, (Object)schemaPattern, (Object)typeNamePattern, (Object)types);
                }
                return this.getUDTsX(catalog, schemaPattern, typeNamePattern, types);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ResultSet getUDTsX(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SqlException {
        this.checkForClosedConnectionX();
        PreparedStatement cs = this.prepareMetaDataQuery("SYSIBM.SQLUDTS(?,?,?,?,?)");
        cs.setStringX(1, catalog);
        cs.setStringX(2, schemaPattern);
        cs.setStringX(3, typeNamePattern);
        String udtTypes = new String();
        for (int i = 0; types != null && i < types.length; ++i) {
            if (i > 0) {
                udtTypes = udtTypes.concat(",");
            }
            udtTypes = udtTypes.concat(String.valueOf(types[i]));
        }
        cs.setStringX(4, udtTypes);
        cs.setStringX(5, this.getOptions());
        return this.executeCatalogQuery(cs);
    }

    private String getOptions() {
        int cursorHold = this.connection_.holdability() == 1 ? 1 : 0;
        return "DATATYPE='JDBC';DYNAMIC=0;REPORTPUBLICPRIVILEGES=1;CURSORHOLD=" + cursorHold;
    }

    private ResultSet executeCatalogQuery(PreparedStatement cs) throws SqlException {
        try {
            return cs.executeQueryX();
        }
        catch (SqlException e) {
            if (e.getErrorCode() == -440) {
                SqlException newException = new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ209.S"));
                newException.setNextException(e);
                throw newException;
            }
            if (e.getErrorCode() == -444) {
                SqlException newException = new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ210.S"));
                newException.setNextException(e);
                throw newException;
            }
            throw e;
        }
    }

    public java.sql.Connection getConnection() throws SQLException {
        this.checkForClosedConnection();
        return this.connection_;
    }

    public boolean supportsNamedParameters() throws SQLException {
        this.checkForClosedConnection();
        return false;
    }

    public boolean supportsMultipleOpenResults() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsGetGeneratedKeys() throws SQLException {
        this.checkForClosedConnection();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getSuperTypes", (Object)catalog, (Object)schemaPattern, (Object)typeNamePattern);
                }
                return this.getSuperTypesX();
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ResultSet getSuperTypesX() throws SqlException {
        this.checkForClosedConnectionX();
        String sql = "SELECT CAST(NULL AS VARCHAR(128)) AS TYPE_CAT,CAST(NULL AS VARCHAR(128)) AS TYPE_SCHEM,VARCHAR('', 128) AS TYPE_NAME,CAST(NULL AS VARCHAR(128)) AS SUPERTYPE_CAT,CAST(NULL AS VARCHAR(128)) AS SUPERTYPE_SCHEM,VARCHAR('', 128) AS SUPERTYPE_NAME FROM SYSIBM.SYSDUMMY1 WHERE 1=0 WITH UR ";
        PreparedStatement ps = this.connection_.prepareDynamicCatalogQuery(sql);
        return ps.executeQueryX();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getSuperTables", (Object)catalog, (Object)schemaPattern, (Object)tableNamePattern);
                }
                return this.getSuperTablesX();
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ResultSet getSuperTablesX() throws SqlException {
        this.checkForClosedConnectionX();
        String sql = "SELECT CAST(NULL AS VARCHAR(128)) AS TABLE_CAT,CAST(NULL AS VARCHAR(128)) AS TABLE_SCHEM,VARCHAR('', 128) AS TABLE_NAME,VARCHAR('', 128) AS SUPERTABLE_NAME FROM SYSIBM.SYSDUMMY1 WHERE 1=0 WITH UR";
        PreparedStatement ps = this.connection_.prepareDynamicCatalogQuery(sql);
        return ps.executeQueryX();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getAttributes", (Object)catalog, (Object)schemaPattern, (Object)typeNamePattern, (Object)attributeNamePattern);
                }
                return this.getAttributesX();
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ResultSet getAttributesX() throws SqlException {
        this.checkForClosedConnectionX();
        String sql = "SELECT CAST(NULL AS VARCHAR(128)) AS TYPE_CAT,CAST(NULL AS VARCHAR(128)) AS TYPE_SCHEM,VARCHAR('', 128) AS TYPE_NAME,VARCHAR('',128) AS ATTR_NAME,0 AS DATA_TYPE,VARCHAR('',129) AS ATTR_TYPE_NAME,0 AS ATTR_SIZE,0 AS DECIMAL_DIGITS,0 AS NUM_PREC_RADIX,2 AS NULLABLE,CAST(NULL AS VARCHAR(254)) AS REMARKS,CAST(NULL AS VARCHAR(128)) AS ATTR_DEF,0 AS SQL_DATA_TYPE,0 AS SQL_DATETIME_SUB,0 AS CHAR_OCTET_LENGTH,0 AS ORDINAL_POSITION,VARCHAR('',128) AS IS_NULLABLE,CAST(NULL AS VARCHAR(128)) AS SCOPE_CATALOG,CAST(NULL AS VARCHAR(128)) AS SCOPE_SCHEMA,CAST(NULL AS VARCHAR(128)) AS SCOPE_TABLE,CAST(NULL AS SMALLINT) AS SOURCE_DATA_TYPE FROM SYSIBM.SYSDUMMY1 WHERE 1=0 WITH UR";
        PreparedStatement ps = this.connection_.prepareDynamicCatalogQuery(sql);
        return ps.executeQueryX();
    }

    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public int getResultSetHoldability() throws SQLException {
        this.checkForClosedConnection();
        return 1;
    }

    public int getDatabaseMajorVersion() throws SQLException {
        this.checkForClosedConnection();
        return this.productLevel_.versionLevel_;
    }

    public int getDatabaseMinorVersion() throws SQLException {
        this.checkForClosedConnection();
        return this.productLevel_.releaseLevel_;
    }

    public int getJDBCMajorVersion() throws SQLException {
        this.checkForClosedConnection();
        return 3;
    }

    public int getJDBCMinorVersion() throws SQLException {
        this.checkForClosedConnection();
        return 0;
    }

    public int getSQLStateType() throws SQLException {
        this.checkForClosedConnection();
        return 2;
    }

    public boolean locatorsUpdateCopy() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public boolean supportsStatementPooling() throws SQLException {
        this.checkForClosedConnection();
        return false;
    }

    protected abstract void computeFeatureSet_();

    private boolean getMetaDataInfoBoolean(int infoCallIndex) throws SQLException {
        try {
            if (this.metaDataInfoIsCached_) {
                return (Integer)this.metaDataInfoCache_[infoCallIndex] != 0;
            }
            this.metaDataInfoCall();
            return (Integer)this.metaDataInfoCache_[infoCallIndex] != 0;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private int getMetaDataInfoInt(int infoCallIndex) throws SQLException {
        try {
            if (this.metaDataInfoIsCached_) {
                return (Integer)this.metaDataInfoCache_[infoCallIndex];
            }
            this.metaDataInfoCall();
            return (Integer)this.metaDataInfoCache_[infoCallIndex];
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private String getMetaDataInfoString(int infoCallIndex) throws SQLException {
        try {
            if (this.metaDataInfoIsCached_) {
                return (String)this.metaDataInfoCache_[infoCallIndex];
            }
            this.metaDataInfoCall();
            return (String)this.metaDataInfoCache_[infoCallIndex];
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private boolean getMetaDataInfoBooleanWithType(int infoCallIndex, int type) throws SQLException {
        boolean clientValue = this.getMetaDataInfoBooleanWithTypeClient(infoCallIndex, type);
        return clientValue;
    }

    private boolean getMetaDataInfoBooleanWithTypeClient(int infoCallIndex, int type) throws SQLException {
        switch (infoCallIndex) {
            case 97: 
            case 98: 
            case 103: 
            case 104: {
                if (this.productLevel_.greaterThanOrEqualTo(10, 2, 0) && type == 1004) {
                    return true;
                }
                return this.getMetaDataInfoBooleanWithTypeServer(infoCallIndex, type);
            }
            case 99: 
            case 105: {
                if (this.productLevel_.greaterThanOrEqualTo(10, 2, 0) && type == 1004) {
                    return false;
                }
                return this.getMetaDataInfoBooleanWithTypeServer(infoCallIndex, type);
            }
        }
        return this.getMetaDataInfoBooleanWithTypeServer(infoCallIndex, type);
    }

    private boolean getMetaDataInfoBooleanWithTypeServer(int infoCallIndex, int type) throws SQLException {
        try {
            String returnedFromSP = null;
            if (this.metaDataInfoIsCached_) {
                returnedFromSP = (String)this.metaDataInfoCache_[infoCallIndex];
            } else {
                this.metaDataInfoCall();
                returnedFromSP = (String)this.metaDataInfoCache_[infoCallIndex];
            }
            StringTokenizer st = new StringTokenizer(returnedFromSP, ",");
            while (st.hasMoreTokens()) {
                if (new Integer(st.nextToken()) != type) continue;
                return true;
            }
            return false;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private boolean getMetaDataInfoInt_SupportsResultSetConcurrency(int infoCallIndex, int type, int concurrency) throws SQLException {
        try {
            String returnedFromSP = null;
            if (this.metaDataInfoIsCached_) {
                returnedFromSP = (String)this.metaDataInfoCache_[infoCallIndex];
            } else {
                this.metaDataInfoCall();
                returnedFromSP = (String)this.metaDataInfoCache_[infoCallIndex];
            }
            StringTokenizer st = new StringTokenizer(returnedFromSP, ";");
            while (st.hasMoreTokens()) {
                StringTokenizer stForConc = new StringTokenizer(st.nextToken(), ",");
                if (new Integer(stForConc.nextToken()) != type) continue;
                while (stForConc.hasMoreTokens()) {
                    if (new Integer(stForConc.nextToken()) != concurrency) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private boolean getMetaDataInfoBoolean_supportsConvert(int infoCallIndex, int fromType, int toType) throws SQLException {
        try {
            String returnedFromSP = null;
            if (this.metaDataInfoIsCached_) {
                returnedFromSP = (String)this.metaDataInfoCache_[infoCallIndex];
            } else {
                this.metaDataInfoCall();
                returnedFromSP = (String)this.metaDataInfoCache_[infoCallIndex];
            }
            StringTokenizer st = new StringTokenizer(returnedFromSP, ";");
            while (st.hasMoreTokens()) {
                StringTokenizer stForType = new StringTokenizer(st.nextToken(), ",");
                if (new Integer(stForType.nextToken()) != fromType) continue;
                while (st.hasMoreTokens()) {
                    if (new Integer(st.nextToken()) != toType) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void metaDataInfoCall() throws SqlException {
        Connection connection = this.connection_;
        synchronized (connection) {
            int ColumnCount;
            PreparedStatement ps = this.prepareMetaDataQuery("SYSIBM.MetaData()");
            ResultSet rs = ps.executeQueryX();
            rs.nextX();
            try {
                ColumnCount = rs.getMetaDataX().getColumnCount();
            }
            catch (SQLException se) {
                throw new SqlException(se);
            }
            for (int infoCallIndex = 0; infoCallIndex < ColumnCount && infoCallIndex < this.metaDataInfoCache_.length; ++infoCallIndex) {
                this.metaDataInfoCache_[infoCallIndex] = rs.getObjectX(infoCallIndex + 1);
            }
            this.metaDataInfoIsCached_ = true;
            rs.closeX();
        }
    }

    public final boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        this.checkForClosedConnection();
        return true;
    }

    public final boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        this.checkForClosedConnection();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getSchemas");
                }
                return this.getSchemasX(catalog, schemaPattern);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ResultSet getSchemasX(String catalog, String schemaPattern) throws SqlException {
        this.checkForClosedConnectionX();
        this.checkServerJdbcVersionX("getSchemas(String, String)", 4, 0);
        String call = "SYSIBM.SQLTABLES(?, ?, '', '', 'GETSCHEMAS=2')";
        PreparedStatement cs = this.prepareMetaDataQuery(call);
        if (catalog == null) {
            cs.setNullX(1, 12);
        } else {
            cs.setStringX(1, catalog);
        }
        if (schemaPattern == null) {
            cs.setNullX(2, 12);
        } else {
            cs.setStringX(2, schemaPattern);
        }
        return cs.executeQueryX();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getClientInfoProperties() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getClientInfoProperties");
                }
                return this.getClientInfoPropertiesX();
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ResultSet getClientInfoPropertiesX() throws SqlException {
        this.checkForClosedConnectionX();
        String sql = "SELECT CAST(NULL AS VARCHAR(128)) AS NAME, CAST(NULL AS INT) AS MAX_LEN, CAST(NULL AS VARCHAR(128)) AS DEFAULT_VALUE, CAST(NULL AS VARCHAR(128)) AS DESCRIPTION FROM SYSIBM.SYSDUMMY1 WHERE 1=0 WITH UR";
        PreparedStatement ps = this.connection_.prepareDynamicCatalogQuery("SELECT CAST(NULL AS VARCHAR(128)) AS NAME, CAST(NULL AS INT) AS MAX_LEN, CAST(NULL AS VARCHAR(128)) AS DEFAULT_VALUE, CAST(NULL AS VARCHAR(128)) AS DESCRIPTION FROM SYSIBM.SYSDUMMY1 WHERE 1=0 WITH UR");
        return ps.executeQueryX();
    }

    private PreparedStatement prepareMetaDataQuery(String cmd) throws SqlException {
        PreparedStatement ps = this.connection_.prepareStatementX("CALL " + cmd, 1003, 1007, this.connection_.holdability(), 2, null, null);
        return ps;
    }

    protected void checkForClosedConnection() throws SQLException {
        try {
            this.checkForClosedConnectionX();
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private void checkForClosedConnectionX() throws SqlException {
        if (this.connection_.isClosedX()) {
            this.agent_.checkForDeferredExceptions();
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("08003"));
        }
        this.agent_.checkForDeferredExceptions();
    }

    protected void checkServerJdbcVersionX(String method, int major, int minor) throws SqlException {
        if (this.serverJdbcMajorVersion < major || this.serverJdbcMajorVersion == major && this.serverJdbcMinorVersion < minor) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.2"), method);
        }
    }
}

