/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.derby.client.am.Agent;
import org.apache.derby.client.am.BatchUpdateException;
import org.apache.derby.client.am.ClientMessageId;
import org.apache.derby.client.am.ColumnMetaData;
import org.apache.derby.client.am.Connection;
import org.apache.derby.client.am.ConnectionCallbackInterface;
import org.apache.derby.client.am.Cursor;
import org.apache.derby.client.am.MaterialStatement;
import org.apache.derby.client.am.PreparedStatement;
import org.apache.derby.client.am.ResultSet;
import org.apache.derby.client.am.Section;
import org.apache.derby.client.am.SqlException;
import org.apache.derby.client.am.SqlWarning;
import org.apache.derby.client.am.Sqlca;
import org.apache.derby.client.am.StatementCallbackInterface;
import org.apache.derby.shared.common.sanity.SanityManager;

public class Statement
implements java.sql.Statement,
StatementCallbackInterface {
    public static final int CLOSE_CURRENT_RESULT = 1;
    public static final int KEEP_CURRENT_RESULT = 2;
    public static final int CLOSE_ALL_RESULTS = 3;
    public MaterialStatement materialStatement_ = null;
    Connection connection_;
    public Section section_;
    Agent agent_;
    private java.sql.Statement owner = null;
    ResultSet resultSet_;
    int updateCount_ = -1;
    int returnValueFromProcedure_;
    static final int executeQueryMethod__ = 1;
    static final int executeUpdateMethod__ = 2;
    static final int executeMethod__ = 3;
    protected int sqlMode_ = 0;
    static final int isQuery__ = 1;
    static final int isCall__ = 2;
    static final int isUpdate__ = 4;
    int sqlUpdateMode_ = 0;
    public static final int isCommitSql__ = 1;
    public static final int isRollbackSql__ = 2;
    static final int isPositionedUpdateDeleteSql__ = 16;
    static final int isInsertSql__ = 32;
    static final int isDeleteSql__ = 64;
    static final int isUpdateSql__ = 128;
    ColumnMetaData resultSetMetaData_;
    public Cursor cachedCursor_ = null;
    public Cursor cachedSingletonRowData_ = null;
    boolean isPreparedStatement_ = false;
    String cursorName_ = null;
    boolean openOnClient_ = true;
    boolean openOnServer_ = false;
    protected int indexOfCurrentResultSet_ = -1;
    ResultSet[] resultSetList_ = null;
    protected static final String TIMEOUT_STATEMENT = "SET STATEMENT_TIMEOUT ";
    protected ArrayList timeoutArrayList = new ArrayList(1);
    protected boolean doWriteTimeout = false;
    int timeout_ = 0;
    int maxRows_ = 0;
    int maxFieldSize_ = 0;
    boolean isAutoCommittableStatement_ = true;
    boolean isCatalogQuery_ = false;
    final ArrayList batch_ = new ArrayList();
    public int resultSetType_ = 1003;
    public int resultSetConcurrency_ = 1007;
    public int resultSetHoldability_;
    public int fetchSize_ = 0;
    public int fetchDirection_ = 1000;
    public Cursor singletonRowData_ = null;
    public int numInvisibleRS_ = 0;
    public String cursorAttributesToSendOnPrepare_ = null;
    public PreparedStatement preparedStatementForAutoGeneratedKeys_;
    public ResultSet generatedKeysResultSet_;
    public String[] generatedKeysColumnNames_;
    public int[] generatedKeysColumnIndexes_;
    public int autoGeneratedKeys_ = 2;
    private SqlWarning warnings_ = null;
    protected boolean isPoolable = false;
    private Section setSpecialRegisterSection_ = null;

    private Statement() {
        this.initStatement();
    }

    private void resetStatement() {
        this.initStatement();
    }

    private void initStatement() {
        this.materialStatement_ = null;
        this.connection_ = null;
        this.agent_ = null;
        this.resultSetType_ = 1003;
        this.resultSetConcurrency_ = 1007;
        this.resultSetHoldability_ = 0;
        this.cursorAttributesToSendOnPrepare_ = null;
        if (this.timeoutArrayList.size() == 0) {
            this.timeoutArrayList.add(null);
        }
        this.initResetStatement();
    }

    private void initResetStatement() {
        this.initResetPreparedStatement();
        if (this.section_ != null) {
            this.section_.free();
        }
        if (this.setSpecialRegisterSection_ != null) {
            this.setSpecialRegisterSection_.free();
            this.setSpecialRegisterSection_ = null;
        }
        this.sqlMode_ = 0;
        this.sqlUpdateMode_ = 0;
        this.resultSetMetaData_ = null;
    }

    protected void initResetPreparedStatement() {
        this.warnings_ = null;
        this.resultSet_ = null;
        this.updateCount_ = -1;
        this.returnValueFromProcedure_ = 0;
        this.openOnClient_ = true;
        this.openOnServer_ = false;
        this.indexOfCurrentResultSet_ = -1;
        this.resultSetList_ = null;
        this.isCatalogQuery_ = false;
        this.isAutoCommittableStatement_ = true;
        this.batch_.clear();
        this.singletonRowData_ = null;
        this.numInvisibleRS_ = 0;
        this.preparedStatementForAutoGeneratedKeys_ = null;
        this.generatedKeysResultSet_ = null;
        this.generatedKeysColumnNames_ = null;
        this.generatedKeysColumnIndexes_ = null;
        this.autoGeneratedKeys_ = 2;
        this.resetUserControllableAttributes();
    }

    private void resetUserControllableAttributes() {
        this.cursorName_ = null;
        this.timeout_ = 0;
        this.doWriteTimeout = false;
        this.maxRows_ = 0;
        this.maxFieldSize_ = 0;
        this.fetchSize_ = 0;
        this.fetchDirection_ = 1000;
        this.isPoolable = this.isPreparedStatement_;
    }

    public void reset(boolean fullReset) throws SqlException {
        if (fullReset) {
            this.connection_.resetStatement(this);
        } else {
            this.initResetStatement();
            this.materialStatement_.reset_();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetForReuse() throws SqlException {
        this.batch_.clear();
        this.clearWarningsX();
        int numberOfResultSetsToClose = 0;
        if (this.resultSetList_ != null) {
            numberOfResultSetsToClose = this.resultSetList_.length;
        }
        try {
            if (this.willTickleServer(numberOfResultSetsToClose, this.connection_.autoCommit_)) {
                this.flowClose();
            } else {
                this.flowCloseOutsideUOW();
            }
        }
        finally {
            this.markResultSetsClosed();
            this.removeClientCursorNameFromCache();
            this.markPreparedStatementForAutoGeneratedKeysClosed();
            if (this.setSpecialRegisterSection_ != null) {
                this.setSpecialRegisterSection_.free();
                this.setSpecialRegisterSection_ = null;
            }
            this.resetUserControllableAttributes();
        }
    }

    public Statement(Agent agent, Connection connection) throws SqlException {
        this();
        this.initStatement(agent, connection);
    }

    public void resetStatement(Agent agent, Connection connection) throws SqlException {
        this.resetStatement();
        this.initStatement(agent, connection);
    }

    private void initStatement(Agent agent, Connection connection) {
        this.agent_ = agent;
        this.connection_ = connection;
    }

    public Statement(Agent agent, Connection connection, int type, int concurrency, int holdability, int autoGeneratedKeys, String[] columnNames, int[] columnIndexes) throws SqlException {
        this(agent, connection);
        this.initStatement(type, concurrency, holdability, autoGeneratedKeys, columnNames, columnIndexes);
    }

    public void resetStatement(Agent agent, Connection connection, int type, int concurrency, int holdability, int autoGeneratedKeys, String[] columnNames, int[] columnIndexes) throws SqlException {
        this.resetStatement(agent, connection);
        this.initStatement(type, concurrency, holdability, autoGeneratedKeys, columnNames, columnIndexes);
    }

    private void initStatement(int type, int concurrency, int holdability, int autoGeneratedKeys, String[] columnNames, int[] columnIndexes) throws SqlException {
        switch (type) {
            case 1003: 
            case 1004: 
            case 1005: {
                this.resultSetType_ = type;
                break;
            }
            default: {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ081.S"), (Object)new Integer(type), (Object)"type", "createStatement()");
            }
        }
        switch (concurrency) {
            case 1007: 
            case 1008: {
                this.resultSetConcurrency_ = concurrency;
                break;
            }
            default: {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ081.S"), (Object)new Integer(concurrency), (Object)"concurrency", "createStatement()");
            }
        }
        switch (holdability) {
            case 1: 
            case 2: {
                this.resultSetHoldability_ = holdability;
                break;
            }
            default: {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ081.S"), (Object)new Integer(holdability), (Object)"holdability", "createStatement()");
            }
        }
        switch (autoGeneratedKeys) {
            case 1: 
            case 2: {
                this.autoGeneratedKeys_ = autoGeneratedKeys;
                break;
            }
            default: {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ081.S"), (Object)new Integer(autoGeneratedKeys), (Object)"autoGeneratedKeys", "createStatement");
            }
        }
        this.generatedKeysColumnNames_ = columnNames;
        this.generatedKeysColumnIndexes_ = columnIndexes;
    }

    protected void finalize() throws Throwable {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry(this, "finalize");
        }
        if (this.openOnClient_) {
            this.markClosed();
        }
        super.finalize();
    }

    protected SqlWarning getSqlWarnings() {
        return this.warnings_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet executeQuery(String sql) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "executeQuery", sql);
                }
                ResultSet resultSet = this.executeQueryX(sql);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "executeQuery", resultSet);
                }
                return resultSet;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private ResultSet executeQueryX(String sql) throws SqlException {
        this.flowExecute(1, sql);
        return this.resultSet_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String sql) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "executeUpdate", sql);
                }
                int updateValue = this.executeUpdateX(sql);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "executeUpdate", updateValue);
                }
                return updateValue;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private int executeUpdateX(String sql) throws SqlException {
        this.flowExecute(2, sql);
        return this.updateCount_;
    }

    public boolean isWrapperFor(Class iface) throws SQLException {
        try {
            this.checkForClosedStatement();
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
        return iface.isInstance(this);
    }

    public boolean isClosed() throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceEntry((Object)this, "isClosed", !this.openOnClient_);
        }
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "isClosed", !this.openOnClient_);
        }
        return !this.openOnClient_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "close");
                }
                this.closeX();
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeX() throws SqlException {
        if (!this.openOnClient_) {
            return;
        }
        int numberOfResultSetsToClose = this.resultSetList_ == null ? 0 : this.resultSetList_.length;
        boolean willTickleServer = this.willTickleServer(numberOfResultSetsToClose, true);
        try {
            if (willTickleServer) {
                this.flowClose();
            } else {
                this.flowCloseOutsideUOW();
            }
        }
        finally {
            this.markClosed(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPoolable() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "isPoolable");
                }
                this.checkForClosedStatement();
                return this.isPoolable;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPoolable(boolean poolable) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setPoolable", poolable);
                }
                this.checkForClosedStatement();
                this.isPoolable = poolable;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public int getMaxFieldSize() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getMaxFieldSize");
            }
            this.checkForClosedStatement();
            return this.maxFieldSize_;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxFieldSize(int max) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setMaxFieldSize", max);
                }
                this.checkForClosedStatement();
                if (max < 0) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ066.S"), new Integer(max));
                }
                this.maxFieldSize_ = max;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public int getMaxRows() throws SQLException {
        try {
            this.checkForClosedStatement();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getMaxRows", this.maxRows_);
            }
            return this.maxRows_;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxRows(int maxRows) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setMaxRows", maxRows);
                }
                this.checkForClosedStatement();
                if (maxRows < 0) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ063.S"), new Integer(maxRows));
                }
                this.maxRows_ = maxRows;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEscapeProcessing(boolean enable) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setEscapeProcessing", enable);
                }
                this.checkForClosedStatement();
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public int getQueryTimeout() throws SQLException {
        try {
            this.checkForClosedStatement();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getQueryTimeout", this.timeout_);
            }
            return this.timeout_;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setQueryTimeout(int seconds) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setQueryTimeout", seconds);
                }
                this.checkForClosedStatement();
                if (seconds < 0) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ074.S"), new Integer(seconds));
                }
                if (seconds != this.timeout_) {
                    this.timeout_ = seconds;
                    this.doWriteTimeout = true;
                }
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public void cancel() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "cancel");
            }
            this.checkForClosedStatement();
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.4"));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public SQLWarning getWarnings() throws SQLException {
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceExit((Object)this, "getWarnings", this.warnings_);
        }
        try {
            this.checkForClosedStatement();
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
        return this.warnings_ == null ? null : this.warnings_.getSQLWarning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearWarnings() throws SQLException {
        Connection connection = this.connection_;
        synchronized (connection) {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "clearWarnings");
            }
            try {
                this.checkForClosedStatement();
            }
            catch (SqlException se) {
                throw se.getSQLException();
            }
            this.clearWarningsX();
        }
    }

    final void clearWarningsX() {
        this.warnings_ = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCursorName(String name) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setCursorName", name);
                }
                this.checkForClosedStatement();
                if (name == null || name.equals("")) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ202.S"), name);
                }
                if (this.resultSet_ != null && this.resultSet_.openOnClient_) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("X0X95.S"), (Object)"setCursorName()", "Statement");
                }
                this.cursorName_ = name;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String sql) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "execute", sql);
                }
                boolean b = this.executeX(sql);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "execute", b);
                }
                return b;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    boolean executeX(String sql) throws SqlException {
        this.flowExecute(3, sql);
        return this.resultSet_ != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public java.sql.ResultSet getResultSet() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getResultSet");
                }
                this.checkForClosedStatement();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getResultSet", this.resultSet_);
                }
                return this.resultSet_;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUpdateCount() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getUpdateCount");
                }
                this.checkForClosedStatement();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getUpdateCount", this.updateCount_);
                }
                return this.updateCount_;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getMoreResults() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "getMoreResults");
                }
                boolean resultIsResultSet = this.getMoreResultsX(3);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getMoreResults", resultIsResultSet);
                }
                return resultIsResultSet;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFetchDirection(int direction) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setFetchDirection", direction);
                }
                this.checkForClosedStatement();
                switch (direction) {
                    case 1000: 
                    case 1001: 
                    case 1002: {
                        this.fetchDirection_ = direction;
                        break;
                    }
                    default: {
                        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ064.S"), new Integer(direction));
                    }
                }
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public int getFetchDirection() throws SQLException {
        try {
            this.checkForClosedStatement();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getFetchDirection", this.fetchDirection_);
            }
            return this.fetchDirection_;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFetchSize(int rows) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "setFetchSize", rows);
                }
                this.checkForClosedStatement();
                if (rows < 0 || this.maxRows_ != 0 && rows > this.maxRows_) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ065.S"), new Integer(rows)).getSQLException();
                }
                this.fetchSize_ = rows;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public int getFetchSize() throws SQLException {
        try {
            this.checkForClosedStatement();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getFetchSize", this.fetchSize_);
            }
            return this.fetchSize_;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public int getResultSetConcurrency() throws SQLException {
        try {
            this.checkForClosedStatement();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getResultSetConcurrency", this.resultSetConcurrency_);
            }
            return this.resultSetConcurrency_;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public int getResultSetType() throws SQLException {
        try {
            this.checkForClosedStatement();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getResultSetType", this.resultSetType_);
            }
            return this.resultSetType_;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBatch(String sql) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "addBatch", sql);
                }
                this.checkForClosedStatement();
                sql = this.connection_.nativeSQLX(sql);
                this.batch_.add(sql);
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBatch() throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "clearBatch");
                }
                this.checkForClosedStatement();
                this.batch_.clear();
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] executeBatch() throws SQLException, BatchUpdateException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry(this, "executeBatch");
                }
                int[] updateCounts = this.executeBatchX();
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "executeBatch", updateCounts);
                }
                return updateCounts;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private int[] executeBatchX() throws SqlException, BatchUpdateException {
        this.checkForClosedStatement();
        this.clearWarningsX();
        this.resultSetList_ = null;
        int[] updateCounts = new int[this.batch_.size()];
        Arrays.fill(updateCounts, -3);
        this.flowExecuteBatch(updateCounts);
        return updateCounts;
    }

    public java.sql.Connection getConnection() throws SQLException {
        try {
            this.checkForClosedStatement();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getConnection", this.connection_);
            }
            return this.connection_;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getMoreResults(int current) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "getMoreResults", current);
                }
                boolean resultIsResultSet = this.getMoreResultsX(current);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "getMoreResults", resultIsResultSet);
                }
                return resultIsResultSet;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    private boolean getMoreResultsX(int current) throws SqlException {
        boolean resultIsResultSet;
        this.checkForClosedStatement();
        this.updateCount_ = -1;
        if (this.resultSetList_ == null) {
            if (this.resultSet_ != null) {
                if (current != 2) {
                    this.resultSet_.closeX();
                }
                this.resultSet_ = null;
            }
            resultIsResultSet = false;
        } else {
            if (this.numInvisibleRS_ == 0 && current == 1 && this.resultSetList_[this.indexOfCurrentResultSet_] != null) {
                this.resultSetList_[this.indexOfCurrentResultSet_].closeX();
            }
            boolean bl = resultIsResultSet = this.indexOfCurrentResultSet_ + 1 < this.resultSetList_.length;
        }
        if (current == 3 && this.numInvisibleRS_ == 0) {
            int numberOfResultSetsToClose = this.resultSetList_ == null ? 0 : this.indexOfCurrentResultSet_ + 1;
            boolean willTickleServer = this.willTickleServer(numberOfResultSetsToClose, false);
            if (willTickleServer) {
                this.flowCloseRetrievedResultSets();
            } else {
                this.flowCloseRetrievedResultSetsOutsideUOW();
            }
        }
        this.resultSet_ = resultIsResultSet ? this.resultSetList_[++this.indexOfCurrentResultSet_] : null;
        return resultIsResultSet;
    }

    public java.sql.ResultSet getGeneratedKeys() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getGeneratedKeys");
            }
            this.checkForClosedStatement();
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceExit((Object)this, "getGeneratedKeys", this.generatedKeysResultSet_);
            }
            return this.generatedKeysResultSet_;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "executeUpdate", (Object)sql, autoGeneratedKeys);
                }
                this.autoGeneratedKeys_ = autoGeneratedKeys;
                int updateValue = this.executeUpdateX(sql);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "executeUpdate", updateValue);
                }
                return updateValue;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "executeUpdate", (Object)sql, (Object)columnIndexes);
                }
                if (columnIndexes != null && columnIndexes.length > 0) {
                    this.autoGeneratedKeys_ = 1;
                }
                this.generatedKeysColumnIndexes_ = columnIndexes;
                int updateValue = this.executeUpdateX(sql);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "executeUpdate", updateValue);
                }
                return updateValue;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "executeUpdate", (Object)sql, (Object)columnNames);
                }
                if (columnNames != null && columnNames.length > 0) {
                    this.autoGeneratedKeys_ = 1;
                }
                this.generatedKeysColumnNames_ = columnNames;
                int updateValue = this.executeUpdateX(sql);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "executeUpdate", updateValue);
                }
                return updateValue;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "execute", (Object)sql, autoGeneratedKeys);
                }
                this.autoGeneratedKeys_ = autoGeneratedKeys;
                boolean b = this.executeX(sql);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "execute", b);
                }
                return b;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "execute", (Object)sql, (Object)columnIndexes);
                }
                if (columnIndexes != null && columnIndexes.length > 0) {
                    this.autoGeneratedKeys_ = 1;
                }
                this.generatedKeysColumnIndexes_ = columnIndexes;
                boolean b = this.executeX(sql);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "execute", b);
                }
                return b;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        try {
            Connection connection = this.connection_;
            synchronized (connection) {
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceEntry((Object)this, "execute", (Object)sql, (Object)columnNames);
                }
                if (columnNames != null && columnNames.length > 0) {
                    this.autoGeneratedKeys_ = 1;
                }
                this.generatedKeysColumnNames_ = columnNames;
                boolean b = this.executeX(sql);
                if (this.agent_.loggingEnabled()) {
                    this.agent_.logWriter_.traceExit((Object)this, "execute", b);
                }
                return b;
            }
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public int getResultSetHoldability() throws SQLException {
        try {
            if (this.agent_.loggingEnabled()) {
                this.agent_.logWriter_.traceEntry(this, "getResultSetHoldability");
            }
            this.checkForClosedStatement();
            return this.resultSetHoldability_;
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    public void writeSetSpecialRegister(ArrayList sqlsttList) throws SqlException {
        if (this.setSpecialRegisterSection_ == null) {
            this.setSpecialRegisterSection_ = this.agent_.sectionManager_.getDynamicSection(1);
        }
        this.materialStatement_.writeSetSpecialRegister_(this.setSpecialRegisterSection_, sqlsttList);
    }

    public void readSetSpecialRegister() throws SqlException {
        SanityManager.ASSERT(this.setSpecialRegisterSection_ != null);
        this.materialStatement_.readSetSpecialRegister_();
    }

    public void writeExecuteImmediate(String sql, Section section) throws SqlException {
        this.materialStatement_.writeExecuteImmediate_(sql, section);
    }

    public void readExecuteImmediate() throws SqlException {
        this.materialStatement_.readExecuteImmediate_();
    }

    public void completeExecuteImmediate(Sqlca sqlca) {
        int sqlcode = this.completeSqlca(sqlca);
        if (sqlcode < 0) {
            return;
        }
        if (sqlca != null) {
            this.updateCount_ = sqlca.getUpdateCount();
        }
    }

    public void readExecuteImmediateForBatch(String sql) throws SqlException {
        this.materialStatement_.readExecuteImmediateForBatch_(sql);
    }

    public void writePrepareDescribeOutput(String sql, Section section) throws SqlException {
        this.materialStatement_.writePrepareDescribeOutput_(sql, section);
    }

    public void readPrepareDescribeOutput() throws SqlException {
        this.materialStatement_.readPrepareDescribeOutput_();
    }

    public void completePrepareDescribeOutput(ColumnMetaData resultSetMetaData, Sqlca sqlca) {
        this.completePrepare(sqlca);
        this.resultSetMetaData_ = resultSetMetaData;
        if (this.agent_.loggingEnabled()) {
            this.agent_.logWriter_.traceResultSetMetaData(this, this.resultSetMetaData_);
        }
    }

    public void writePrepare(String sql, Section section) throws SqlException {
        this.materialStatement_.writePrepare_(sql, section);
    }

    public void readPrepare() throws SqlException {
        this.materialStatement_.readPrepare_();
    }

    public void completePrepare(Sqlca sqlca) {
        int sqlcode = this.completeSqlca(sqlca);
        if (sqlcode < 0) {
            return;
        }
        this.markPrepared();
    }

    public void writeOpenQuery(Section section, int fetchSize, int resultSetType) throws SqlException {
        this.materialStatement_.writeOpenQuery_(section, fetchSize, resultSetType);
    }

    public void readOpenQuery() throws SqlException {
        this.materialStatement_.readOpenQuery_();
    }

    public void completeOpenQuery(Sqlca sqlca, ResultSet resultSet) {
        this.completeSqlca(sqlca);
        this.resultSet_ = resultSet;
        if (resultSet == null) {
            return;
        }
        resultSet.resultSetMetaData_ = this.resultSetMetaData_;
        resultSet.resultSetMetaData_.resultSetConcurrency_ = resultSet.resultSetConcurrency_;
        resultSet.createLOBColumnTracker();
        if (this.cachedCursor_ == null && this.isPreparedStatement_) {
            this.cachedCursor_ = this.resultSet_.cursor_;
        }
        if (sqlca != null && sqlca.getSqlCode() < 0) {
            return;
        }
        this.openOnServer_ = true;
        resultSet.cursor_.rowsRead_ = 0;
        if (this.resultSet_.fetchSize_ == 0 && (this.resultSet_.resultSetType_ == 1004 || this.resultSet_.resultSetType_ == 1005)) {
            this.resultSet_.setFetchSize_(64);
        }
    }

    public void completeExecuteCallOpenQuery(Sqlca sqlca, ResultSet resultSet, ColumnMetaData resultSetMetaData, Section generatedSection) {
        resultSet.completeSqlca(sqlca);
        resultSet.resultSetMetaData_ = resultSetMetaData;
        resultSet.createLOBColumnTracker();
        if (sqlca != null && sqlca.getSqlCode() < 0) {
            return;
        }
        this.openOnServer_ = true;
        resultSet.cursor_.rowsRead_ = 0;
        resultSet.generatedSection_ = generatedSection;
        if (resultSet.fetchSize_ == 0) {
            resultSet.fetchSize_ = 64;
        }
    }

    public void writeExecuteCall(boolean outputExpected, String procedureName, Section section, int fetchSize, boolean suppressResultSets, int resultSetType, ColumnMetaData parameterMetaData, Object[] inputs) throws SqlException {
        this.materialStatement_.writeExecuteCall_(outputExpected, procedureName, section, fetchSize, suppressResultSets, resultSetType, parameterMetaData, inputs);
    }

    public void readExecuteCall() throws SqlException {
        this.materialStatement_.readExecuteCall_();
    }

    public void completeExecuteCall(Sqlca sqlca, Cursor singletonParams, ResultSet[] resultSets) {
        this.completeExecuteCall(sqlca, singletonParams);
        this.resultSetList_ = resultSets;
        if (resultSets != null) {
            this.resultSet_ = resultSets[0];
        }
        this.indexOfCurrentResultSet_ = 0;
    }

    public void completeExecuteCall(Sqlca sqlca, Cursor singletonParams) {
        this.completeExecute(sqlca);
        if (sqlca != null && sqlca.getSqlCode() < 0) {
            this.singletonRowData_ = null;
        } else {
            this.singletonRowData_ = singletonParams;
            if (this.cachedSingletonRowData_ == null && this.isPreparedStatement_) {
                this.cachedSingletonRowData_ = this.singletonRowData_;
            }
        }
    }

    public void completeExecute(Sqlca sqlca) {
        if (sqlca == null) {
            return;
        }
        int sqlcode = sqlca.getSqlCode();
        if (sqlcode < 0) {
            this.agent_.accumulateReadException(new SqlException(this.agent_.logWriter_, sqlca));
            this.returnValueFromProcedure_ = sqlcode;
        } else {
            this.updateCount_ = sqlca.getUpdateCount();
            if (this.sqlMode_ == 2) {
                this.updateCount_ = -1;
                this.returnValueFromProcedure_ = sqlca.getSqlErrd()[0];
            }
            if (sqlcode > 0 && sqlcode != 466 && sqlcode != 100) {
                this.accumulateWarning(new SqlWarning(this.agent_.logWriter_, sqlca));
            }
        }
    }

    public void setUpdateCount(int updateCount) {
        this.updateCount_ = updateCount;
    }

    protected final void setOwner(java.sql.Statement owner) {
        this.owner = owner;
    }

    final java.sql.Statement getOwner() {
        return this.owner;
    }

    private boolean willTickleServer(int number, boolean allowAutoCommits) throws SqlException {
        boolean requiresAutocommit = false;
        if (this.resultSetList_ != null) {
            for (int i = 0; i < number; ++i) {
                if (this.resultSetList_[i] == null) continue;
                if (this.resultSetList_[i].openOnServer_) {
                    return true;
                }
                if (this.resultSetList_[i].autoCommitted_ || !allowAutoCommits) continue;
                requiresAutocommit = true;
            }
        } else if (this.generatedKeysResultSet_ != null && this.generatedKeysResultSet_.openOnServer_) {
            this.generatedKeysResultSet_.writeClose();
        } else if (this.resultSet_ != null) {
            if (this.resultSet_.openOnServer_) {
                return true;
            }
            if (!this.resultSet_.autoCommitted_ && allowAutoCommits) {
                requiresAutocommit = true;
            }
        }
        if (this.connection_.autoCommit_ && requiresAutocommit) {
            if (this.connection_.isXAConnection_) {
                return this.connection_.getXAState() == 0;
            }
            return true;
        }
        return false;
    }

    private void flowClose() throws SqlException {
        this.agent_.beginWriteChain(this);
        this.writeClose(true);
        this.agent_.flow(this);
        this.readClose(true);
        this.agent_.endReadChain();
    }

    private void flowCloseOutsideUOW() throws SqlException {
        this.agent_.beginWriteChainOutsideUOW();
        this.writeClose(true);
        this.agent_.flowOutsideUOW();
        this.readClose(true);
        this.agent_.endReadChain();
    }

    final void writeClose(boolean allowAutoCommits) throws SqlException {
        this.writeCloseResultSets(allowAutoCommits);
    }

    final void readClose(boolean allowAutoCommits) throws SqlException {
        this.readCloseResultSets(allowAutoCommits);
    }

    final boolean writeCloseResultSets(boolean allowAutoCommits) throws SqlException {
        int numberOfResultSetsToClose = this.resultSetList_ == null ? 0 : this.resultSetList_.length;
        return this.writeCloseResultSets(numberOfResultSetsToClose, allowAutoCommits);
    }

    boolean writeCloseResultSets(int number, boolean allowAutoCommits) throws SqlException {
        boolean requiresAutocommit = false;
        if (this.resultSetList_ != null) {
            for (int i = 0; i < number; ++i) {
                if (this.resultSetList_[i] == null) continue;
                if (this.resultSetList_[i].openOnServer_) {
                    this.resultSetList_[i].writeClose();
                }
                if (this.resultSetList_[i].autoCommitted_ || !allowAutoCommits) continue;
                requiresAutocommit = true;
            }
        } else if (this.generatedKeysResultSet_ != null && this.generatedKeysResultSet_.openOnServer_) {
            this.generatedKeysResultSet_.writeClose();
        } else if (this.resultSet_ != null) {
            if (this.resultSet_.openOnServer_) {
                this.resultSet_.writeClose();
            }
            if (!this.resultSet_.autoCommitted_ && allowAutoCommits) {
                requiresAutocommit = true;
            }
        }
        if (this.connection_.autoCommit_ && requiresAutocommit && this.isAutoCommittableStatement_) {
            this.connection_.writeAutoCommit();
            if (this.connection_.isXAConnection_) {
                return this.connection_.getXAState() == 0;
            }
            return true;
        }
        return false;
    }

    final void readCloseResultSets(boolean allowAutoCommits) throws SqlException {
        int numberOfResultSetsToClose = this.resultSetList_ == null ? 0 : this.resultSetList_.length;
        this.readCloseResultSets(numberOfResultSetsToClose, allowAutoCommits);
    }

    void readCloseResultSets(int number, boolean allowAutoCommits) throws SqlException {
        boolean requiredAutocommit = false;
        if (this.resultSetList_ != null) {
            for (int i = 0; i < number; ++i) {
                if (this.resultSetList_[i] == null) continue;
                if (this.resultSetList_[i].openOnServer_) {
                    this.resultSetList_[i].readClose();
                } else {
                    this.resultSetList_[i].markClosed();
                }
                if (this.resultSetList_[i].autoCommitted_ || !allowAutoCommits) continue;
                requiredAutocommit = true;
            }
        } else if (this.generatedKeysResultSet_ != null) {
            if (this.generatedKeysResultSet_.openOnServer_) {
                this.generatedKeysResultSet_.readClose();
            } else {
                this.generatedKeysResultSet_.markClosed();
            }
        } else if (this.resultSet_ != null) {
            if (this.resultSet_.openOnServer_) {
                this.resultSet_.readClose();
            } else {
                this.resultSet_.markClosed();
            }
            if (!this.resultSet_.autoCommitted_ && allowAutoCommits) {
                requiredAutocommit = true;
            }
        }
        if (this.connection_.autoCommit_ && requiredAutocommit && this.isAutoCommittableStatement_) {
            this.connection_.readAutoCommit();
        }
    }

    private void flowCloseRetrievedResultSets() throws SqlException {
        int numberOfResultSetsToClose = this.resultSetList_ == null ? 0 : this.indexOfCurrentResultSet_ + 1;
        this.agent_.beginWriteChain(this);
        this.writeCloseResultSets(numberOfResultSetsToClose, false);
        this.agent_.flow(this);
        this.readCloseResultSets(numberOfResultSetsToClose, false);
        this.agent_.endReadChain();
    }

    private void flowCloseRetrievedResultSetsOutsideUOW() throws SqlException {
        int numberOfResultSetsToClose = this.resultSetList_ == null ? 0 : this.indexOfCurrentResultSet_ + 1;
        this.agent_.beginWriteChainOutsideUOW();
        this.writeCloseResultSets(numberOfResultSetsToClose, false);
        this.agent_.flowOutsideUOW();
        this.readCloseResultSets(numberOfResultSetsToClose, false);
        this.agent_.endReadChain();
    }

    public int completeSqlca(Sqlca sqlca) {
        if (sqlca == null) {
            return 0;
        }
        int sqlcode = sqlca.getSqlCode();
        if (sqlcode < 0) {
            this.connection_.agent_.accumulateReadException(new SqlException(this.agent_.logWriter_, sqlca));
        } else if (sqlcode > 0) {
            this.accumulateWarning(new SqlWarning(this.agent_.logWriter_, sqlca));
        }
        return sqlcode;
    }

    public void completeExecuteSetStatement(Sqlca sqlca) {
    }

    void markClosedOnServer() {
        if (this.section_ != null) {
            this.section_.free();
            this.section_ = null;
        }
        this.openOnServer_ = false;
        if (this.materialStatement_ != null) {
            this.materialStatement_.markClosedOnServer_();
        }
    }

    void markClosed() {
        this.markClosed(false);
    }

    void markClosed(boolean removeListener) {
        this.openOnClient_ = false;
        this.markResultSetsClosed();
        this.removeClientCursorNameFromCache();
        this.markPreparedStatementForAutoGeneratedKeysClosed();
        this.markClosedOnServer();
        if (this.resultSetMetaData_ != null) {
            this.resultSetMetaData_.markClosed();
            this.resultSetMetaData_ = null;
        }
        if (removeListener) {
            this.connection_.openStatements_.remove(this);
        }
        if (this.setSpecialRegisterSection_ != null) {
            this.setSpecialRegisterSection_.free();
            this.setSpecialRegisterSection_ = null;
        }
    }

    void markPreparedStatementForAutoGeneratedKeysClosed() {
        if (this.preparedStatementForAutoGeneratedKeys_ != null) {
            this.preparedStatementForAutoGeneratedKeys_.markClosed();
        }
    }

    void markResultSetsClosed() {
        this.markResultSetsClosed(false);
    }

    final void markResultSetsClosed(boolean removeListener) {
        if (this.resultSetList_ != null) {
            for (int i = 0; i < this.resultSetList_.length; ++i) {
                if (this.resultSetList_[i] != null) {
                    this.resultSetList_[i].markClosed(removeListener);
                }
                this.resultSetList_[i] = null;
            }
        }
        if (this.generatedKeysResultSet_ != null) {
            this.generatedKeysResultSet_.markClosed(removeListener);
        }
        if (this.resultSet_ != null) {
            this.resultSet_.markClosed(removeListener);
        }
        this.resultSet_ = null;
        this.resultSetList_ = null;
        this.generatedKeysResultSet_ = null;
    }

    private void flowExecute(int executeType, String sql) throws SqlException {
        this.checkForClosedStatement();
        this.clearWarningsX();
        sql = this.escape(sql);
        this.parseSqlAndSetSqlModes(sql);
        this.checkAutoGeneratedKeysParameters();
        this.updateCount_ = this.sqlMode_ == 4 ? 0 : -1;
        this.checkForAppropriateSqlMode(executeType, this.sqlMode_);
        if (this.sqlMode_ == 1) {
            this.checkForDuplicateCursorName();
        }
        boolean timeoutSent = false;
        this.agent_.beginWriteChain(this);
        boolean piggybackedAutoCommit = this.writeCloseResultSets(true);
        ResultSet scrollableRS = null;
        Section newSection = null;
        boolean repositionedCursor = false;
        if (this.doWriteTimeout && this.timeout_ > 0) {
            this.timeoutArrayList.set(0, TIMEOUT_STATEMENT + this.timeout_);
            this.writeSetSpecialRegister(this.timeoutArrayList);
            timeoutSent = true;
        }
        switch (this.sqlMode_) {
            case 1: {
                newSection = this.agent_.sectionManager_.getDynamicSection(this.resultSetHoldability_);
                this.writePrepareDescribeOutput(sql, newSection);
                this.writeOpenQuery(newSection, this.fetchSize_, this.resultSetType_);
                break;
            }
            case 4: {
                String[] sqlAndCursorName;
                String cursorName = null;
                if ((this.sqlUpdateMode_ == 64 || this.sqlUpdateMode_ == 128) && (sqlAndCursorName = this.extractCursorNameFromWhereCurrentOf(sql)) != null) {
                    cursorName = sqlAndCursorName[0];
                    sql = sqlAndCursorName[1];
                }
                if (cursorName != null) {
                    newSection = this.agent_.sectionManager_.getPositionedUpdateSection(cursorName, true);
                    if (newSection == null) {
                        throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ202.S"), cursorName);
                    }
                    scrollableRS = this.agent_.sectionManager_.getPositionedUpdateResultSet(cursorName);
                    if (scrollableRS != null && !scrollableRS.isRowsetCursor_ && !(repositionedCursor = scrollableRS.repositionScrollableResultSetBeforeJDBC1PositionedUpdateDelete())) {
                        scrollableRS = null;
                    }
                    if (newSection.getClientCursorName() != null && cursorName.compareTo(newSection.getClientCursorName()) == 0) {
                        sql = this.substituteClientCursorNameWithServerCursorName(sql, newSection);
                    }
                    this.writeExecuteImmediate(sql, newSection);
                } else {
                    newSection = this.agent_.sectionManager_.getDynamicSection(this.resultSetHoldability_);
                    this.writeExecuteImmediate(sql, newSection);
                    if (this.sqlUpdateMode_ == 32 && this.autoGeneratedKeys_ == 1) {
                        this.prepareAutoGeneratedKeysStatement();
                        this.writeOpenQuery(this.preparedStatementForAutoGeneratedKeys_.section_, this.preparedStatementForAutoGeneratedKeys_.fetchSize_, this.preparedStatementForAutoGeneratedKeys_.resultSetType_);
                    }
                }
                if (!this.connection_.autoCommit_) break;
                this.connection_.writeAutoCommit();
                break;
            }
            case 2: {
                newSection = this.writeExecuteCall(sql, false);
            }
        }
        this.agent_.flow(this);
        this.readCloseResultSets(true);
        if (timeoutSent) {
            this.readSetSpecialRegister();
        }
        if (piggybackedAutoCommit) {
            this.connection_.completeTransactionStart();
        }
        this.markResultSetsClosed(true);
        this.markClosedOnServer();
        this.section_ = newSection;
        switch (this.sqlMode_) {
            case 1: {
                this.readPrepareDescribeOutput();
                this.readOpenQuery();
                if (this.resultSet_ == null) break;
                this.resultSet_.parseScrollableRowset();
                this.setupCursorNameCacheAndMappings();
                break;
            }
            case 4: {
                if (scrollableRS != null && !scrollableRS.isRowsetCursor_) {
                    scrollableRS.readPositioningFetch_();
                }
                this.readExecuteImmediate();
                if (this.sqlUpdateMode_ == 32 && this.autoGeneratedKeys_ == 1) {
                    this.readPrepareAutoGeneratedKeysStatement();
                    this.preparedStatementForAutoGeneratedKeys_.readOpenQuery();
                    this.generatedKeysResultSet_ = this.preparedStatementForAutoGeneratedKeys_.resultSet_;
                    this.preparedStatementForAutoGeneratedKeys_.resultSet_ = null;
                }
                if (!this.connection_.autoCommit_) break;
                this.connection_.readAutoCommit();
                break;
            }
            case 2: {
                this.readPrepare();
                this.readExecuteCall();
            }
        }
        this.agent_.endReadChain();
        if (this.resultSet_ != null && this.resultSet_.resultSetHoldability_ != this.resultSetHoldability_ && this.sqlMode_ != 2) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ204.S"), new Integer(this.resultSetHoldability_));
        }
        if (this.sqlMode_ == 2) {
            this.parseStorProcReturnedScrollableRowset();
            this.checkForStoredProcResultSetCount(executeType);
            if (this.connection_.autoCommit_ && this.resultSet_ == null && this.resultSetList_ == null) {
                this.connection_.flowAutoCommit();
            }
        }
        if (executeType == 2 && this.updateCount_ < 0) {
            this.updateCount_ = 0;
        }
    }

    void flowExecuteBatch(int[] updateCounts) throws SqlException, BatchUpdateException {
        String sql;
        int i;
        SqlException chainBreaker = null;
        boolean isCallCataloguedBestGuess = true;
        this.agent_.beginBatchedWriteChain(this);
        for (i = 0; i < this.batch_.size(); ++i) {
            boolean flowSQL = true;
            sql = (String)this.batch_.get(i);
            this.parseSqlAndSetSqlModes(sql);
            try {
                this.checkForInvalidBatchedSql(sql);
            }
            catch (SqlException e) {
                flowSQL = false;
            }
            if (!flowSQL) continue;
            if (this.section_ != null) {
                this.section_.free();
            }
            if (this.sqlMode_ != 2) {
                this.section_ = this.agent_.sectionManager_.getDynamicSection(this.resultSetHoldability_);
                this.writeExecuteImmediate(sql, this.section_);
                continue;
            }
            this.section_ = this.writeExecuteCall(sql, true);
        }
        if (this.connection_.autoCommit_) {
            this.connection_.writeAutoCommit();
        }
        this.agent_.flowBatch(this, this.batch_.size());
        try {
            for (i = 0; i < this.batch_.size(); ++i) {
                this.agent_.setBatchedExceptionLabelIndex(i);
                SqlException invalidSQLCaughtByClient = null;
                sql = (String)this.batch_.get(i);
                this.parseSqlAndSetSqlModes(sql);
                try {
                    this.checkForInvalidBatchedSql(sql);
                }
                catch (SqlException e) {
                    invalidSQLCaughtByClient = e;
                }
                if (invalidSQLCaughtByClient == null) {
                    this.updateCount_ = -1;
                    if (this.sqlMode_ != 2) {
                        this.readExecuteImmediateForBatch(sql);
                    } else {
                        if (isCallCataloguedBestGuess) {
                            this.readPrepare();
                        }
                        this.readExecuteCall();
                    }
                } else {
                    this.agent_.accumulateReadException(invalidSQLCaughtByClient);
                    this.updateCount_ = -3;
                    invalidSQLCaughtByClient = null;
                }
                updateCounts[i] = this.updateCount_;
                if (updateCounts[i] != -1) continue;
                updateCounts[i] = 0;
            }
            this.agent_.disableBatchedExceptionTracking();
            if (this.connection_.autoCommit_) {
                this.connection_.readAutoCommit();
            }
        }
        catch (SqlException e) {
            chainBreaker = e;
            chainBreaker.setNextException(new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ211.S")));
        }
        this.batch_.clear();
        this.agent_.endBatchedReadChain(updateCounts, chainBreaker);
    }

    private Section writeExecuteCall(String sql, boolean isBatch) throws SqlException {
        Section newSection = null;
        newSection = this.agent_.sectionManager_.getDynamicSection(this.resultSetHoldability_);
        this.writePrepare(sql, newSection);
        this.writeExecuteCall(false, null, newSection, this.fetchSize_, isBatch, this.resultSetType_, null, null);
        return newSection;
    }

    public void listenToUnitOfWork() {
    }

    public void completeLocalCommit(Iterator listenerIterator) {
    }

    public void completeLocalRollback(Iterator listenerIterator) {
    }

    public void accumulateWarning(SqlWarning e) {
        if (this.warnings_ == null) {
            this.warnings_ = e;
        } else {
            this.warnings_.setNextWarning(e);
        }
    }

    private void markPrepared() {
        this.openOnServer_ = true;
        this.listenToUnitOfWork();
    }

    protected String getJdbcStatementInterfaceName() {
        return "java.sql.Statement";
    }

    void parseSqlAndSetSqlModes(String sql) throws SqlException {
        String delims = "\t\n\r\f=? (";
        StringTokenizer tokenizer = null;
        String firstToken = null;
        if (sql.trim().startsWith("--")) {
            int lastEndLine = -1;
            String endline = "\n\r\f";
            tokenizer = new StringTokenizer(sql, endline, true);
            while (tokenizer.hasMoreTokens()) {
                firstToken = tokenizer.nextToken();
                if (endline.indexOf(firstToken) != -1) {
                    lastEndLine = sql.indexOf(firstToken, lastEndLine + 1);
                    continue;
                }
                if (firstToken.trim().startsWith("--")) continue;
            }
            if (firstToken.startsWith("--")) {
                this.sqlMode_ = 1;
                return;
            }
            tokenizer = new StringTokenizer(sql.substring(lastEndLine + 1), delims);
        } else {
            tokenizer = new StringTokenizer(sql, delims);
        }
        if (!tokenizer.hasMoreTokens()) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ206.S"), sql);
        }
        this.sqlUpdateMode_ = 0;
        firstToken = tokenizer.nextToken();
        if (firstToken.equalsIgnoreCase("select") || firstToken.equalsIgnoreCase("values")) {
            this.sqlMode_ = 1;
        } else if (firstToken.equalsIgnoreCase("call")) {
            this.sqlMode_ = 2;
        } else {
            this.parseUpdateSql(firstToken);
        }
    }

    private void parseUpdateSql(String firstToken) throws SqlException {
        this.sqlMode_ = 4;
        if (firstToken.equalsIgnoreCase("insert")) {
            this.sqlUpdateMode_ = 32;
        }
        if (firstToken.equalsIgnoreCase("delete")) {
            this.sqlUpdateMode_ = 64;
        }
        if (firstToken.equalsIgnoreCase("update")) {
            this.sqlUpdateMode_ = 128;
        }
    }

    String getProcedureName(String sql) throws SqlException {
        StringTokenizer tokenizer = new StringTokenizer(sql, "\t\n\r\f= (?");
        if (!tokenizer.hasMoreTokens()) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ206.S"), sql);
        }
        String firstToken = tokenizer.nextToken();
        if (!firstToken.equalsIgnoreCase("call")) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("42X74"));
        }
        if (!tokenizer.hasMoreTokens()) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("42X74"));
        }
        return tokenizer.nextToken();
    }

    public static String upperCaseProcedureName(String procedureName) throws SqlException {
        char[] charArray = null;
        if (procedureName.indexOf("\"") == -1) {
            return procedureName.toUpperCase();
        }
        charArray = procedureName.toCharArray();
        boolean inStringLiteral = false;
        for (int i = 0; i < charArray.length; ++i) {
            if (charArray[i] == '\"') {
                inStringLiteral = !inStringLiteral;
                continue;
            }
            if (inStringLiteral || charArray[i] == '.') continue;
            charArray[i] = Character.toUpperCase(charArray[i]);
        }
        return new String(charArray);
    }

    final void checkForAppropriateSqlMode(int executeType, int sqlMode) throws SqlException {
        if (executeType == 1 && sqlMode == 4) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ207.S"));
        }
        if (executeType == 2 && sqlMode == 1) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("X0Y79.S"));
        }
    }

    private void checkResultSetCount(int executeType) throws SqlException {
        switch (executeType) {
            case 1: {
                if (this.resultSetList_ != null && this.resultSetList_.length > 1) {
                    throw new SqlException(this.agent_.logWriter_, new ClientMessageId("X0Y78.S.1"), (Object)this.getJdbcStatementInterfaceName(), this.getJdbcStatementInterfaceName());
                }
                if (this.resultSet_ != null && this.resultSetList_.length != 0) break;
                ClientMessageId messageId = new ClientMessageId("X0Y78.S.2");
                throw new SqlException(this.agent_.logWriter_, messageId, (Object)this.getJdbcStatementInterfaceName(), this.getJdbcStatementInterfaceName());
            }
            case 2: {
                if (this.resultSet_ == null || this.resultSetList_.length <= 0) break;
                ClientMessageId messageId = new ClientMessageId("X0Y79.S");
                throw new SqlException(this.agent_.logWriter_, messageId);
            }
        }
    }

    protected final void checkForStoredProcResultSetCount(int executeType) throws SqlException {
        try {
            this.checkResultSetCount(executeType);
        }
        catch (SqlException se) {
            if (this.connection_.autoCommit_) {
                this.connection_.flowRollback();
            }
            throw se;
        }
    }

    final void checkForClosedStatement() throws SqlException {
        if (this.connection_ == null || this.connection_.isClosed()) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("08003"));
        }
        if (!this.openOnClient_) {
            this.agent_.checkForDeferredExceptions();
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ012.S"), "Statement");
        }
        this.agent_.checkForDeferredExceptions();
    }

    void checkForInvalidBatchedSql(String sql) throws SqlException {
        if (sql == null) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ067.S"));
        }
        if (this.sqlMode_ != 2 && (this.sqlMode_ != 4 || this.sqlUpdateMode_ != 32 && this.sqlUpdateMode_ != 64 && this.sqlUpdateMode_ != 128 && this.sqlUpdateMode_ != 0)) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("42ZA1"), sql);
        }
    }

    protected void checkForDuplicateCursorName() throws SqlException {
        if (this.cursorName_ != null && this.connection_.clientCursorNameCache_.containsKey(this.cursorName_)) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ203.S"), this.cursorName_);
        }
    }

    protected void setupCursorNameCacheAndMappings() {
        if (this.cursorName_ != null) {
            this.agent_.sectionManager_.mapCursorNameToQuerySection(this.cursorName_, this.section_);
            this.section_.setClientCursorName(this.cursorName_);
            this.connection_.clientCursorNameCache_.put(this.cursorName_, this.cursorName_);
        } else {
            this.agent_.sectionManager_.mapCursorNameToQuerySection(this.section_.getServerCursorName(), this.section_);
        }
        this.mapCursorNameToResultSet();
    }

    String[] extractCursorNameFromWhereCurrentOf(String sql) {
        int whereIndex;
        String lowerSql = sql.toLowerCase();
        int currentIndex = lowerSql.lastIndexOf("current");
        if (currentIndex != -1 && (whereIndex = lowerSql.lastIndexOf("where")) != -1) {
            String[] whereCurrentOf = new String[]{"where", "current", "of"};
            StringTokenizer st = new StringTokenizer(sql.substring(whereIndex));
            while (st.hasMoreTokens()) {
                String cursorName;
                if (!st.nextToken().equalsIgnoreCase(whereCurrentOf[0]) || !st.nextToken().equalsIgnoreCase(whereCurrentOf[1]) || !st.nextToken().equalsIgnoreCase(whereCurrentOf[2])) continue;
                String oldCursorName = cursorName = st.nextToken();
                int originalCursorNameLength = cursorName.length();
                int index = sql.lastIndexOf(cursorName);
                cursorName = cursorName.charAt(0) == '\"' && cursorName.charAt(cursorName.length() - 1) == '\"' ? cursorName.substring(1, cursorName.length() - 1) : cursorName.toUpperCase();
                sql = sql.length() > index + originalCursorNameLength ? sql.substring(0, index) + cursorName + sql.substring(index + oldCursorName.length(), sql.length()) : sql.substring(0, index) + cursorName;
                return new String[]{cursorName, sql};
            }
        }
        return null;
    }

    protected String substituteClientCursorNameWithServerCursorName(String sql, Section section) throws SqlException {
        String clientCursorName = section.getClientCursorName();
        int index = sql.lastIndexOf(clientCursorName);
        if (sql.length() > index + clientCursorName.length()) {
            return sql.substring(0, index) + section.getServerCursorNameForPositionedUpdate() + sql.substring(index + clientCursorName.length(), sql.length());
        }
        return sql.substring(0, index) + section.getServerCursorNameForPositionedUpdate();
    }

    public ConnectionCallbackInterface getConnectionCallbackInterface() {
        return this.connection_;
    }

    void resetCursorNameAndRemoveFromWhereCurrentOfMappings() {
        if (this.section_ != null) {
            this.agent_.sectionManager_.removeCursorNameToResultSetMapping(this.cursorName_, this.section_.getServerCursorNameForPositionedUpdate());
            this.agent_.sectionManager_.removeCursorNameToResultSetMapping(this.cursorName_, this.section_.getServerCursorName());
            this.agent_.sectionManager_.removeCursorNameToQuerySectionMapping(this.cursorName_, this.section_.getServerCursorNameForPositionedUpdate());
        }
    }

    void mapCursorNameToResultSet() {
        if (this.cursorName_ != null) {
            this.agent_.sectionManager_.mapCursorNameToResultSet(this.cursorName_, this.resultSet_);
        } else {
            this.agent_.sectionManager_.mapCursorNameToResultSet(this.section_.getServerCursorName(), this.resultSet_);
        }
    }

    void parseStorProcReturnedScrollableRowset() throws SqlException {
        if (this.resultSetList_ != null) {
            for (int i = 0; i < this.resultSetList_.length; ++i) {
                if (!this.resultSetList_[i].scrollable_ || !this.resultSetList_[i].cursor_.dataBufferHasUnprocessedData()) continue;
                this.resultSetList_[i].parseScrollableRowset();
                if (!this.resultSetList_[i].rowCountIsUnknown()) continue;
                this.resultSetList_[i].getRowCount();
            }
        }
    }

    String escape(String sql) throws SqlException {
        String nativeSQL = sql;
        nativeSQL = this.connection_.nativeSQLX(sql);
        return nativeSQL;
    }

    String cacheCursorAttributesToSendOnPrepare() throws SqlException {
        StringBuffer cursorAttributes = new StringBuffer();
        if (this.resultSetType_ == 1005) {
            cursorAttributes.append("SENSITIVE STATIC SCROLL ");
        } else if (this.resultSetType_ == 1004) {
            cursorAttributes.append("INSENSITIVE SCROLL ");
        }
        if (this.resultSetConcurrency_ == 1008) {
            cursorAttributes.append("FOR UPDATE ");
        }
        if (this.resultSetHoldability_ == 1) {
            cursorAttributes.append("WITH HOLD ");
        }
        return cursorAttributes == null || cursorAttributes.toString().equals("") ? null : cursorAttributes.toString();
    }

    void getPreparedStatementForAutoGeneratedKeys() throws SqlException {
        if (this.preparedStatementForAutoGeneratedKeys_ == null) {
            String s = "select IDENTITY_VAL_LOCAL() from SYSIBM.SYSDUMMY1";
            this.preparedStatementForAutoGeneratedKeys_ = this.connection_.newPreparedStatement_(s, 1003, 1007, 1, 2, null, null);
            StringBuffer cursorAttributes = new StringBuffer();
            cursorAttributes.append("WITH HOLD ");
            this.preparedStatementForAutoGeneratedKeys_.cursorAttributesToSendOnPrepare_ = cursorAttributes.toString();
        }
    }

    void prepareAutoGeneratedKeysStatement() throws SqlException {
        this.getPreparedStatementForAutoGeneratedKeys();
        if (!this.preparedStatementForAutoGeneratedKeys_.openOnServer_) {
            this.preparedStatementForAutoGeneratedKeys_.materialPreparedStatement_.writePrepareDescribeOutput_(this.preparedStatementForAutoGeneratedKeys_.sql_, this.preparedStatementForAutoGeneratedKeys_.section_);
        }
    }

    void readPrepareAutoGeneratedKeysStatement() throws SqlException {
        if (!this.preparedStatementForAutoGeneratedKeys_.openOnServer_) {
            this.preparedStatementForAutoGeneratedKeys_.materialPreparedStatement_.readPrepareDescribeOutput_();
        }
    }

    void checkAutoGeneratedKeysParameters() throws SqlException {
        if (this.autoGeneratedKeys_ != 2 && this.autoGeneratedKeys_ != 1) {
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("XJ081.S"), (Object)new Integer(this.autoGeneratedKeys_), (Object)"autoGeneratedKeys", "Statement.execute()/executeQuery()");
        }
        if (this.sqlUpdateMode_ == 32) {
            if (this.generatedKeysColumnNames_ != null && this.generatedKeysColumnNames_.length > 1) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("X0X0D.S"), new Integer(this.generatedKeysColumnNames_.length));
            }
            if (this.generatedKeysColumnIndexes_ != null && this.generatedKeysColumnIndexes_.length > 1) {
                throw new SqlException(this.agent_.logWriter_, new ClientMessageId("X0X0D.S"), new Integer(this.generatedKeysColumnIndexes_.length));
            }
        }
    }

    public ColumnMetaData getGuessedResultSetMetaData() {
        return this.resultSetMetaData_;
    }

    public boolean isQueryMode() {
        return this.sqlMode_ == 1;
    }

    protected void removeClientCursorNameFromCache() {
        if (this.cursorName_ != null && this.connection_.clientCursorNameCache_.containsKey(this.cursorName_)) {
            this.connection_.clientCursorNameCache_.remove(this.cursorName_);
        }
    }

    public void resultSetCommitting(ResultSet closingRS) throws SqlException {
        this.resultSetCommitting(closingRS, false);
    }

    public boolean resultSetCommitting(ResultSet closingRS, boolean writeChain) throws SqlException {
        if (!this.connection_.autoCommit_ || closingRS.autoCommitted_) {
            return false;
        }
        if (this.resultSetList_ != null) {
            for (int i = 0; i < this.resultSetList_.length; ++i) {
                ResultSet crs = this.resultSetList_[i];
                if (crs == null || !crs.openOnClient_ || crs == closingRS) continue;
                return false;
            }
        }
        if (writeChain) {
            this.connection_.writeAutoCommit();
            return true;
        }
        if (this.connection_.flowAutoCommit()) {
            this.markAutoCommitted();
            return true;
        }
        return false;
    }

    public void markAutoCommitted() {
        if (this.resultSetList_ != null) {
            for (int i = 0; i < this.resultSetList_.length; ++i) {
                if (this.resultSetList_[i] == null) continue;
                this.resultSetList_[i].markAutoCommitted();
            }
        } else if (this.resultSet_ != null) {
            this.resultSet_.markAutoCommitted();
        }
    }

    protected SQLException jdbc3FeatureNotSupported(boolean checkStatement) throws SQLException {
        try {
            if (checkStatement) {
                this.checkForClosedStatement();
            }
            throw new SqlException(this.agent_.logWriter_, new ClientMessageId("0A000.S.1"));
        }
        catch (SqlException se) {
            throw se.getSQLException();
        }
    }

    protected SQLException jdbc3FeatureNotSupported() throws SQLException {
        return this.jdbc3FeatureNotSupported(true);
    }
}

