/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.io.LimitObjectInput;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.store.raw.Compensation;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.Undoable;
import org.apache.derby.iapi.store.raw.data.RawContainerHandle;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.util.ByteArray;
import org.apache.derby.impl.store.raw.data.ContainerBasicOperation;
import org.apache.derby.impl.store.raw.data.ContainerUndoOperation;

public class ContainerOperation
extends ContainerBasicOperation
implements Undoable {
    protected byte operation;
    protected transient boolean hasCreateByteArray = true;
    protected ByteArray createByteArray;
    protected static final byte CREATE = 1;
    protected static final byte DROP = 2;
    protected static final byte REMOVE = 4;

    protected ContainerOperation(RawContainerHandle hdl, byte operation) throws StandardException {
        super(hdl);
        this.operation = operation;
    }

    public ContainerOperation() {
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeByte(this.operation);
        if (this.operation == 1) {
            try {
                this.createByteArray = this.containerHdl.logCreateContainerInfo();
            }
            catch (StandardException se) {
                throw new IOException(se.toString());
            }
            this.createByteArray.writeExternal(out);
        }
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.operation = in.readByte();
        if (this.operation == 1 && this.hasCreateByteArray) {
            this.createByteArray = new ByteArray();
            this.createByteArray.readExternal(in);
        }
    }

    public int getTypeFormatId() {
        return 242;
    }

    protected RawContainerHandle findContainerForRedoRecovery(RawTransaction xact) throws StandardException {
        SanityManager.ASSERT(this.createByteArray != null, "cannot reCreate container in load tran, createByteArray is null");
        long sid = this.containerId.getSegmentId();
        long cid = this.containerId.getContainerId();
        xact.reCreateContainerForRedoRecovery(sid, cid, this.createByteArray);
        return xact.openDroppedContainer(this.containerId, null);
    }

    public final void doMe(Transaction tran, LogInstant instant, LimitObjectInput in) throws StandardException {
        switch (this.operation) {
            case 2: {
                this.containerHdl.dropContainer(instant, true);
                break;
            }
            case 4: {
                this.containerHdl.removeContainer(instant);
                break;
            }
        }
        this.releaseResource(tran);
    }

    public void undoMe(Transaction tran, RawContainerHandle hdl, LogInstant CLRInstant, LimitObjectInput in) throws StandardException {
        switch (this.operation) {
            case 2: {
                SanityManager.ASSERT(hdl != null, "container handle is null");
                SanityManager.ASSERT(hdl.getContainerStatus() != 4, "Undoing a drop but the container status is not dropped");
                hdl.dropContainer(CLRInstant, false);
                break;
            }
            case 1: {
                hdl.removeContainer(CLRInstant);
                break;
            }
            case 4: {
                SanityManager.THROWASSERT("cannot undo REMOVE, should not have generated a CLR in the first place");
            }
        }
        this.releaseResource(tran);
    }

    public Compensation generateUndo(Transaction tran, LimitObjectInput in) throws StandardException {
        if (this.operation == 4) {
            return null;
        }
        RawContainerHandle undoContainerHandle = this.findContainer(tran);
        return new ContainerUndoOperation(undoContainerHandle, this);
    }

    public String toString() {
        String str = super.toString();
        switch (this.operation) {
            case 1: {
                str = str + " CREATE container " + this.containerId;
                break;
            }
            case 2: {
                str = str + " DROP container " + this.containerId;
                break;
            }
            case 4: {
                str = str + " REMOVE container " + this.containerId;
            }
        }
        return str;
    }
}

