/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.jdbc;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import org.apache.derby.iapi.jdbc.BrokeredConnection;
import org.apache.derby.iapi.jdbc.BrokeredConnectionControl;
import org.apache.derby.iapi.jdbc.EngineConnection;
import org.apache.derby.iapi.services.sanity.SanityManager;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.impl.jdbc.EmbedCallableStatement;
import org.apache.derby.impl.jdbc.EmbedConnection;
import org.apache.derby.impl.jdbc.EmbedPreparedStatement;
import org.apache.derby.impl.jdbc.Util;
import org.apache.derby.jdbc.Driver20;
import org.apache.derby.jdbc.ReferenceableDataSource;

class EmbedPooledConnection
implements PooledConnection,
BrokeredConnectionControl {
    private static int idCounter = 0;
    private int connectionId = this.nextId();
    private String connString;
    private ArrayList eventListener;
    private int eventIterators;
    EmbedConnection realConnection;
    int defaultIsolationLevel;
    private boolean defaultReadOnly;
    BrokeredConnection currentConnectionHandle;
    final ReferenceableDataSource dataSource;
    private final String username;
    private final String password;
    private final boolean requestPassword;
    protected boolean isActive;

    private synchronized int nextId() {
        return idCounter++;
    }

    EmbedPooledConnection(ReferenceableDataSource ds, String u, String p, boolean requestPassword) throws SQLException {
        this.dataSource = ds;
        this.username = u;
        this.password = p;
        this.requestPassword = requestPassword;
        this.isActive = true;
        this.openRealConnection();
    }

    String getUsername() {
        if (this.username == null || this.username.equals("")) {
            return "APP";
        }
        return this.username;
    }

    String getPassword() {
        if (this.password == null) {
            return "";
        }
        return this.password;
    }

    public synchronized Connection getConnection() throws SQLException {
        this.checkActive();
        if (this.realConnection == null) {
            this.openRealConnection();
        } else {
            this.resetRealConnection();
        }
        this.closeCurrentConnectionHandle();
        Connection c = this.getNewCurrentConnectionHandle();
        return c;
    }

    final void openRealConnection() throws SQLException {
        Connection rc = this.dataSource.getConnection(this.username, this.password, this.requestPassword);
        this.realConnection = (EmbedConnection)rc;
        this.defaultIsolationLevel = rc.getTransactionIsolation();
        this.defaultReadOnly = rc.isReadOnly();
        if (this.currentConnectionHandle != null) {
            this.realConnection.setApplicationConnection(this.currentConnectionHandle);
        }
    }

    final Connection getNewCurrentConnectionHandle() {
        BrokeredConnection applicationConnection = this.currentConnectionHandle = ((Driver20)this.realConnection.getLocalDriver()).newBrokeredConnection(this);
        this.realConnection.setApplicationConnection(applicationConnection);
        return applicationConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeCurrentConnectionHandle() throws SQLException {
        if (this.currentConnectionHandle != null) {
            ArrayList tmpEventListener = this.eventListener;
            this.eventListener = null;
            try {
                this.currentConnectionHandle.close();
            }
            finally {
                this.eventListener = tmpEventListener;
            }
            this.currentConnectionHandle = null;
        }
    }

    void resetRealConnection() throws SQLException {
        this.realConnection.rollback();
        this.realConnection.clearWarnings();
        if (this.realConnection.getTransactionIsolation() != this.defaultIsolationLevel) {
            this.realConnection.setTransactionIsolation(this.defaultIsolationLevel);
        }
        if (!this.realConnection.getAutoCommit()) {
            this.realConnection.setAutoCommit(true);
        }
        if (this.realConnection.isReadOnly() != this.defaultReadOnly) {
            this.realConnection.setReadOnly(this.defaultReadOnly);
        }
        if (this.realConnection.getHoldability() != 1) {
            this.realConnection.setHoldability(1);
        }
        this.realConnection.resetFromPool();
        SanityManager.ASSERT(this.realConnection.transactionIsIdle(), "real connection should have been idle at this point");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws SQLException {
        if (!this.isActive) {
            return;
        }
        this.closeCurrentConnectionHandle();
        try {
            if (this.realConnection != null && !this.realConnection.isClosed()) {
                this.realConnection.close();
            }
        }
        finally {
            this.realConnection = null;
            this.isActive = false;
            this.eventListener = null;
        }
    }

    public final synchronized void addConnectionEventListener(ConnectionEventListener listener) {
        if (!this.isActive) {
            return;
        }
        if (listener == null) {
            return;
        }
        if (this.eventListener == null) {
            this.eventListener = new ArrayList();
        } else if (this.eventIterators > 0) {
            this.eventListener = (ArrayList)this.eventListener.clone();
        }
        this.eventListener.add(listener);
    }

    public final synchronized void removeConnectionEventListener(ConnectionEventListener listener) {
        if (listener == null || this.eventListener == null) {
            return;
        }
        if (this.eventIterators > 0) {
            this.eventListener = (ArrayList)this.eventListener.clone();
        }
        this.eventListener.remove(listener);
    }

    public synchronized EngineConnection getRealConnection() throws SQLException {
        this.checkActive();
        return this.realConnection;
    }

    public synchronized LanguageConnectionContext getLanguageConnection() throws SQLException {
        this.checkActive();
        return this.realConnection.getLanguageConnection();
    }

    public synchronized void notifyError(SQLException exception) {
        if (exception.getErrorCode() < 40000) {
            return;
        }
        this.fireConnectionEventListeners(exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireConnectionEventListeners(SQLException exception) {
        if (this.eventListener != null && !this.eventListener.isEmpty()) {
            ConnectionEvent event = new ConnectionEvent(this, exception);
            ++this.eventIterators;
            try {
                Iterator it = this.eventListener.iterator();
                while (it.hasNext()) {
                    ConnectionEventListener l = (ConnectionEventListener)it.next();
                    if (exception == null) {
                        l.connectionClosed(event);
                        continue;
                    }
                    l.connectionErrorOccurred(event);
                }
            }
            finally {
                --this.eventIterators;
            }
        }
    }

    final void checkActive() throws SQLException {
        if (!this.isActive) {
            throw Util.noCurrentConnection();
        }
    }

    public boolean isIsolationLevelSetUsingSQLorJDBC() throws SQLException {
        if (this.realConnection != null) {
            return this.realConnection.getLanguageConnection().isIsolationLevelSetUsingSQLorJDBC();
        }
        return false;
    }

    public void resetIsolationLevelFlag() throws SQLException {
        this.realConnection.getLanguageConnection().resetIsolationLevelFlagUsedForSQLandJDBC();
    }

    public void notifyException(SQLException sqle) {
        this.notifyError(sqle);
    }

    public void checkAutoCommit(boolean autoCommit) throws SQLException {
    }

    public int checkHoldCursors(int holdability, boolean downgrade) throws SQLException {
        return holdability;
    }

    public void checkSavepoint() throws SQLException {
    }

    public void checkRollback() throws SQLException {
    }

    public void checkCommit() throws SQLException {
    }

    public void checkClose() throws SQLException {
        if (this.realConnection != null) {
            this.realConnection.checkForTransactionInProgress();
        }
    }

    public synchronized boolean closingConnection() throws SQLException {
        this.currentConnectionHandle = null;
        this.fireConnectionEventListeners(null);
        return false;
    }

    public Statement wrapStatement(Statement s) throws SQLException {
        return s;
    }

    public PreparedStatement wrapStatement(PreparedStatement ps, String sql, Object generatedKeys) throws SQLException {
        EmbedPreparedStatement ps_ = (EmbedPreparedStatement)ps;
        ps_.setBrokeredConnectionControl(this);
        return ps_;
    }

    public CallableStatement wrapStatement(CallableStatement cs, String sql) throws SQLException {
        EmbedCallableStatement cs_ = (EmbedCallableStatement)cs;
        cs_.setBrokeredConnectionControl(this);
        return cs_;
    }

    public String toString() {
        if (this.connString == null) {
            String physicalConnString = this.isActive ? this.realConnection.toString() : "<none>";
            this.connString = this.getClass().getName() + "@" + this.hashCode() + " " + "(ID = " + this.connectionId + "), " + "Physical Connection = " + physicalConnString;
        }
        return this.connString;
    }

    public void onStatementClose(PreparedStatement statement) {
    }

    public void onStatementErrorOccurred(PreparedStatement statement, SQLException sqle) {
    }
}

