/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.rm.internal.validation.databuilders;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.cosmos.rm.internal.validation.artifacts.ReferenceDescriptor;
import org.eclipse.cosmos.rm.internal.validation.common.SMLValidatorUtil;
import org.eclipse.cosmos.rm.internal.validation.databuilders.AbstractTrackerDataBuilder;
import org.eclipse.cosmos.rm.internal.validation.reference.ReferenceContext;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceExtractor
extends AbstractTrackerDataBuilder<List<ReferenceDescriptor>> {
    public static final String ID = "org.eclipse.cosmos.rm.validation.ReferenceExtractor";
    private boolean uriElementHit;
    private StringBuffer currentReference = new StringBuffer();
    private List<ReferenceDescriptor> references = new ArrayList<ReferenceDescriptor>();
    private List<ReferenceContext> contextReferences = new ArrayList<ReferenceContext>();
    private boolean isSMLRef = false;
    private ReferenceContext refContext;
    private int refContextStack = 0;

    public ReferenceExtractor() {
        super.addEvent(1);
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        super.startElement(uri, localName, name, attributes);
        String value = attributes.getValue("http://www.w3.org/ns/sml", "ref");
        if (value != null) {
            this.isSMLRef = SMLValidatorUtil.isTrue(value.toString());
            if (this.isSMLRef) {
                this.refContext = new ReferenceContext(this.getFilePath(), this.getLocator().getLineNumber());
                this.refContext.setNamespace(uri);
                this.refContext.setElementName(localName);
                this.refContext.setNodePath(this.getNodePath());
                this.contextReferences.add(this.refContext);
                String[] aliases = this.getAliases();
                this.refContext.setAliases(aliases);
                if (aliases == null || aliases.length <= 0) {
                    this.refContext.setDocumentPosition(this.getOrphanInx());
                }
                if ((value = attributes.getValue("http://www.w3.org/ns/sml", "nilref")) != null) {
                    this.refContext.setNilref(SMLValidatorUtil.isTrue(value.toString()));
                }
                this.refContextStack = 0;
            }
        }
        if (this.isSMLRef && uri.equals(this.refContext.getNamespace()) && localName.equals(this.refContext.getElementName())) {
            ++this.refContextStack;
        } else if ("http://www.w3.org/ns/sml".equals(uri) && "uri".equals(localName) && this.isSMLRef) {
            this.uriElementHit = true;
        }
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        URI saveBaseURI = this.getCurrentBaseURI();
        super.endElement(uri, localName, name);
        if (this.isSMLRef && uri.equals(this.refContext.getNamespace()) && localName.equals(this.refContext.getElementName())) {
            --this.refContextStack;
            if (this.refContextStack == 0) {
                this.isSMLRef = false;
                this.refContext = null;
            }
        } else if ("http://www.w3.org/ns/sml".equals(uri) && "uri".equals(localName) && this.refContext != null) {
            this.uriElementHit = false;
            ReferenceDescriptor ref = new ReferenceDescriptor(this.getFilePath(), this.getContextLineNumber() - 1, this.currentReference.toString(), saveBaseURI);
            this.references.add(ref);
            this.currentReference = new StringBuffer();
            this.refContext.addReferenceScheme(ref);
            ref.setContext(this.refContext);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.uriElementHit) {
            String string = new String(ch, start, length);
            if (this.currentReference.length() > 0 && string.charAt(0) == '\n' && string.trim().length() > 0) {
                this.currentReference.append(' ');
            }
            this.currentReference.append(string.trim());
        }
    }

    @Override
    public List<ReferenceDescriptor> getDataStructure() {
        return this.references;
    }

    public List<ReferenceContext> getContextReferences() {
        return this.contextReferences;
    }
}

