/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.provisional.dr.drs.service.handler.cmdbf;

import java.io.PrintWriter;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.cmdbf.AbstractFormatter;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.cmdbf.IFormatter;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IParameters;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLtoNodeListFormatter
extends AbstractFormatter
implements IFormatter {
    public void render(PrintWriter output, IParameters input, Element graphResponse) throws Exception {
        StringBuffer buffer = new StringBuffer("{ identifier: \"object\",  label: \"title\",  items:[");
        buffer.append(this.renderElement(graphResponse, true, this.getId(graphResponse)));
        buffer.append("]}");
        output.println(buffer.toString());
    }

    protected Object getId(Object value) {
        return this.idResolver.getId(value);
    }

    protected StringBuffer renderElement(Element elem, boolean rootElement, Object id) {
        NodeList children = elem.getChildNodes();
        StringBuffer buffer = new StringBuffer();
        StringBuffer childBuffer = new StringBuffer();
        String childrenStr = "";
        StringBuffer textContent = null;
        int count = 0;
        int x = 0;
        while (x < children.getLength()) {
            Node node = children.item(x);
            if (node.getNodeType() == 1) {
                Object nodeId = this.getId(node);
                childBuffer.append(this.renderElement((Element)node, false, nodeId));
                if (childrenStr == "") {
                    childrenStr = String.valueOf(childrenStr) + "[";
                }
                if (count > 0) {
                    childrenStr = String.valueOf(childrenStr) + ",";
                }
                childrenStr = String.valueOf(childrenStr) + "{_reference:\"" + nodeId + "\"}";
                ++count;
            }
            if (node.getNodeType() == 3) {
                node.getNodeValue();
            }
            ++x;
        }
        if (!rootElement) {
            buffer.append(",{title:\"" + elem.getNodeName() + "\",nodeClass:\"element\",object:\"" + id + "\"");
        } else {
            buffer.append("{title:\"" + elem.getNodeName() + "\",nodeClass:\"rootElement\",object:\"" + id + "\"");
        }
        buffer.append(", store:\"[");
        buffer.append("{name:'node', properties:[");
        buffer.append("{name:'nodeName', value:'").append(elem.getNodeName()).append("'}");
        buffer.append(",{name:'prefix', value:'").append(elem.getPrefix()).append("'}");
        buffer.append(",{name:'namespaceURI', value:'").append(elem.getNamespaceURI()).append("'}");
        buffer.append(",{name:'baseURI', value:'").append(elem.getBaseURI()).append("'}");
        buffer.append(",{name:'localName', value:'").append(elem.getLocalName()).append("'}");
        NamedNodeMap attributes = elem.getAttributes();
        if (attributes.getLength() > 0) {
            buffer.append("]},");
            buffer.append("{name:'attributes', properties:[");
            int x2 = 0;
            while (x2 < attributes.getLength()) {
                Node attribute = attributes.item(x2);
                if (x2 > 0) {
                    buffer.append(",");
                }
                buffer.append("{name:'" + attribute.getNodeName() + "', value:'").append(attribute.getNodeValue()).append("'}");
                ++x2;
            }
        }
        if (textContent != null) {
            buffer.append("]},");
            buffer.append("{name:'text content', properties:[");
            buffer.append("{name:'content', value:'").append(textContent).append("'}");
        }
        buffer.append("]}]\"");
        if (childrenStr != "") {
            childrenStr = String.valueOf(childrenStr) + "]";
            buffer.append(", children:").append(childrenStr);
            buffer.append("}");
            buffer.append(childBuffer);
        } else {
            buffer.append("}");
        }
        return buffer;
    }
}

