/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.provisional.cmdbf.registration;

import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ResourceBundle;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.context.ServiceContext;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.INotificationHandlerFactory;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.deregistration.service.ICMDBfDeregistrationOperation;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.deregistration.service.impl.CMDBfDeregistrationOperation;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.deregistration.transform.DeregistrationOutputTransformer;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.deregistration.transform.output.artifacts.IDeregisterResponse;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.service.ICMDBfRegistrationOperation;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.service.impl.CMDBfRegistrationOperation;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.RegistrationOutputTransformer;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.output.artifacts.IRegisterResponse;

public abstract class AbstractRegistrationService {
    private ICMDBfRegistrationOperation registrationOperation;
    private ICMDBfDeregistrationOperation deregistrationOperation;
    protected Logger logger = null;

    public void init(ServiceContext serviceContext) {
        this.logger = Logger.getLogger(this.getClass());
        this.logger.setResourceBundle(ResourceBundle.getBundle("org.eclipse.cosmos.dc.provisional.cmdbf.messages"));
    }

    public AbstractRegistrationService() {
        INotificationHandlerFactory factory = this.getNotificationHandlerFactory();
        this.registrationOperation = new CMDBfRegistrationOperation(factory, null);
        this.deregistrationOperation = new CMDBfDeregistrationOperation(factory, null);
    }

    public OMElement Register(OMElement registerRequest) throws CMDBfServiceException {
        OMElement documentElement = null;
        IRegisterResponse result = null;
        result = this.registrationOperation.execute((Reader)new StringReader(registerRequest.toString()));
        InputStream output = RegistrationOutputTransformer.transform((IRegisterResponse)result);
        XMLStreamReader parser = null;
        try {
            parser = XMLInputFactory.newInstance().createXMLStreamReader(output);
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            documentElement = builder.getDocumentElement();
        }
        catch (XMLStreamException e) {
            this.logger.l7dlog((Priority)Level.ERROR, "XMLStreamReader_ERROR", (Throwable)e);
            throw new CMDBfServiceException(0, 9, e.getMessage());
        }
        return documentElement;
    }

    public OMElement Deregister(OMElement deregisterRequest) throws CMDBfServiceException {
        OMElement documentElement = null;
        IDeregisterResponse result = null;
        result = this.deregistrationOperation.execute((Reader)new StringReader(deregisterRequest.toString()));
        InputStream output = DeregistrationOutputTransformer.transform((IDeregisterResponse)result);
        XMLStreamReader parser = null;
        try {
            parser = XMLInputFactory.newInstance().createXMLStreamReader(output);
            StAXOMBuilder builder = new StAXOMBuilder(parser);
            documentElement = builder.getDocumentElement();
        }
        catch (XMLStreamException e) {
            this.logger.l7dlog((Priority)Level.ERROR, "XMLStreamReader_ERROR", (Throwable)e);
            throw new CMDBfServiceException(0, 16, e.getMessage());
        }
        return documentElement;
    }

    public abstract INotificationHandlerFactory getNotificationHandlerFactory();

    public ICMDBfRegistrationOperation getRegistrationOperation() {
        return this.registrationOperation;
    }

    public ICMDBfDeregistrationOperation getDeregistrationOperation() {
        return this.deregistrationOperation;
    }
}

