/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts;

import java.net.URI;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.IXMLWritable;

/**
 * Represents the <prefixMapping> element in the query structure
 * 
 * 
 * @author David Whiteman
 */
public interface IPrefixMapping extends IXMLWritable
{
	/**
	 * Answer the prefix in this mapping
	 * 
	 * @return
	 */
	public String getPrefix();

	/**
	 * Set the prefix in this mapping to <code>name</code>
	 * 
	 * @param name
	 */
	public void setPrefix(String name);

	/**
	 * Answer the namespace in this mapping as a URI
	 * 
	 * @return
	 */
	public URI getNamespace();

	/**
	 * Set the namespace in this mapping as a URI
	 * 
	 * @param value
	 */
	public void setNamespace(URI value);
}
