/**********************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.smlif.editor;

import org.eclipse.cosmos.rm.internal.smlif.common.SMLMessages;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

/**
 * A contributor class used for the SML-IF editor
 * 
 * @author Ali Mehregani
 */
public class SMLIFEditorContributor extends MultiPageEditorActionBarContributor
{
	/**
	 * The last active editor part
	 */
	private IEditorPart lastEditorPart;
	
	/**
	 * The find/replace action
	 */
	private FindReplaceAction findReplaceAction;
	
	protected IAction getAction(ITextEditor editor, String actionID)
	{
		if (actionID.equals(ITextEditorActionConstants.FIND) && editor != null)
		{
			if (findReplaceAction == null)
				findReplaceAction = new FindReplaceAction(SMLMessages.getBundleForConstructedKeys(), "Editor.FindReplace.",  editor);
			return findReplaceAction;
		}
		return (editor == null ? null : editor.getAction(actionID));
	}
	
	/**
	 * @see org.eclipse.ui.part.MultiPageEditorActionBarContributor#setActivePage(org.eclipse.ui.IEditorPart)
	 */
	public void setActivePage(IEditorPart activeEditor)
	{
		if (lastEditorPart == activeEditor)
			return;

		lastEditorPart = activeEditor;
		IActionBars actionBars = getActionBars();
		if (actionBars == null) 
			return;
				
		/* Add the required actions: find, copy, select all, bookmark */
		ITextEditor textEditor = (activeEditor instanceof ITextEditor) ? (ITextEditor) activeEditor : null;
		actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), getAction(textEditor, ITextEditorActionConstants.COPY));
		actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), getAction(textEditor, ITextEditorActionConstants.SELECT_ALL));
		actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), getAction(textEditor, ITextEditorActionConstants.FIND));
		actionBars.setGlobalActionHandler(IDEActionFactory.BOOKMARK.getId(), getAction(textEditor, IDEActionFactory.BOOKMARK.getId()));
		actionBars.updateActionBars();
	}
}
