/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.rm.internal.validation.reference;

import java.net.URISyntaxException;

/**
 * This interface represents a reference expression used to reference
 * an element in a document.
 * 
 * @author Ali Mehregani
 */
public interface IReferenceExpression
{
	/**
	 * Returns the document reference.  If <code>isTransformed</code> returns
	 * false, then <code>transform</code> is called before the document
	 * reference is returned. 
	 * 
	 * 
	 * @return A reference to the document containing the element that is
	 * being referenced.
	 * @throws URISyntaxException 
	 */
	public String getDocumentReference() throws URISyntaxException;
	
	
	/**
	 * The trasnformation of a reference is the process of converting a
	 * reference from a relative reference to an absolute one.
	 * @throws URISyntaxException 
	 *
	 */
	public void transform() throws URISyntaxException;
	
	
	/**
	 * Returns true if this reference has already been transformed; false 
	 * otherwise.
	 *  
	 * @return true if already transformed; false otherwise.
	 */
	public boolean isTransformed();
}
