/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.internal.cmdbf.services.registration.transform.output.artifacts;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.CMDBfServicesUtil;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.ICMDBfServicesConstants;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.output.artifacts.IInstanceResponse;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.output.artifacts.IResponse;

/**
 * @author David Whiteman
 */
public abstract class Response implements IResponse {
	
	List<IInstanceResponse> responses;

	public Response() {
		super();
		this.responses = new ArrayList<IInstanceResponse>();
	}

	public void addInstanceResponse(IInstanceResponse instanceResponse) {
		this.responses.add(instanceResponse);
	}

	public IInstanceResponse[] getInstanceResponses() 
	{
		return responses.toArray(new IInstanceResponse[responses.size()]);
	}

	public void toXML(StringWriter writer, int indent) {
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(ICMDBfServicesConstants.OPEN_ANGLE_BRACKET+ICMDBfServicesConstants.CMDBF_PREFIX + getElementName()+" xmlns:" + ICMDBfServicesConstants.CMDBF_PREFIX_RAW + "=\""+ICMDBfServicesConstants.CMDBF_MODEL_NAMESPACE+ICMDBfServicesConstants.DOUBLE_QUOTE+ICMDBfServicesConstants.CLOSE_ANGLE_BRACKET+ICMDBfServicesConstants.nl);
		
		CMDBfServicesUtil.outputListToXML(writer, indent+1, responses);
		
		CMDBfServicesUtil.addIndent(writer, indent);
		writer.write(CMDBfServicesUtil.endTagFor(ICMDBfServicesConstants.CMDBF_PREFIX + getElementName())+ICMDBfServicesConstants.nl);
	}

	protected abstract String getElementName();
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((responses == null) ? 0 : responses.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final Response other = (Response) obj;
		if (responses == null) {
			if (other.responses != null)
				return false;
		} else if (!responses.equals(other.responses))
			return false;
		return true;
	}

}
