/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.output.artifacts.IRegistrationServiceOutputArtifactFactory;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.output.artifacts.RegisterOutputArtifactFactory;

/**
 * SAX parser that builds IRegisterResponse object from XML input
 * 
 * 
 * @author David Whiteman
 */
public class RegistrationOutputStreamHandler extends AbstractOutputStreamHandler {
	public RegistrationOutputStreamHandler(
			IRegistrationServiceOutputArtifactFactory artifactFactory) {
		super(artifactFactory);
	}

	protected String getResponseElementName() {
		return IRegistrationTransformerConstants.REGISTER_RESPONSE_ELEMENT;
	}

	@Override
	protected IRegistrationServiceOutputArtifactFactory createArtifactFactory() {
		return RegisterOutputArtifactFactory.getInstance();
	}

}
