/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons;

import java.util.List;
import java.util.Vector;
import org.eclipse.cosmos.me.sdd.schema.ObjectFactory;
import org.eclipse.cosmos.me.sdd.schema.RelationshipConstraintType;
import org.eclipse.cosmos.me.sdd.schema.ResourceType;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.DisplayTextCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.PropertyCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.ResourceCompare;
import org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons.StringCompare;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationshipConstraintCompare {
    protected static Vector<RelationshipConstraintType> merge(List<RelationshipConstraintType> rcs, List<RelationshipConstraintType> rcs2) {
        Vector<RelationshipConstraintType> toRemove = new Vector<RelationshipConstraintType>();
        for (RelationshipConstraintType o1 : rcs) {
            for (RelationshipConstraintType o2 : rcs2) {
                if (toRemove.contains(o2) || !RelationshipConstraintCompare.equals(o1, o2)) continue;
                toRemove.add(o2);
                o1 = RelationshipConstraintCompare.merge(o1, o2);
            }
        }
        rcs2.removeAll(toRemove);
        Vector<RelationshipConstraintType> finals = new Vector<RelationshipConstraintType>();
        finals.addAll(rcs);
        finals.addAll(rcs2);
        return finals;
    }

    protected static RelationshipConstraintType merge(RelationshipConstraintType rc, RelationshipConstraintType rc2) {
        ObjectFactory objectFactory = new ObjectFactory();
        RelationshipConstraintType merged = objectFactory.createRelationshipConstraintType();
        merged.setRelatedResourceRef(rc.getRelatedResourceRef());
        merged.setType(rc.getType());
        merged.setDescription(DisplayTextCompare.merge(rc.getDescription(), rc2.getDescription()));
        merged.setShortDescription(DisplayTextCompare.merge(rc.getShortDescription(), rc2.getShortDescription()));
        merged.getProperty().addAll(rc.getProperty());
        return merged;
    }

    protected static boolean equals(RelationshipConstraintType rc, RelationshipConstraintType rc2) {
        if (!ResourceCompare.equals((ResourceType)rc.getRelatedResourceRef(), (ResourceType)rc2.getRelatedResourceRef())) {
            return false;
        }
        if (!StringCompare.equals(rc.getType(), rc2.getType())) {
            return false;
        }
        return PropertyCompare.equals(rc.getProperty(), rc2.getProperty());
    }
}

