/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.sdd.tests.common.validation;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import junit.framework.TestCase;
import org.eclipse.cosmos.me.sdd.common.validation.XMLValidationError;
import org.eclipse.cosmos.me.sdd.common.validation.plugin.SchemaValidationRule;
import org.eclipse.cosmos.me.sdd.tests.common.validation.AllTests;
import org.xml.sax.SAXParseException;

public class SchemaValidationRule_Test
extends TestCase {
    private String fSep = System.getProperty("file.separator");

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testSchemaValidationRule_ExistingSchema() throws FileNotFoundException, IOException {
        File[] files = new File[]{new File("sdd_schema/sdd-common-1.0.xsd")};
        SchemaValidationRule validationRule = new SchemaValidationRule(Arrays.asList(files));
        SchemaValidationRule_Test.assertNotNull((Object)validationRule);
    }

    public void testSchemaValidationRule_MissingSchema() throws IOException {
        try {
            File[] files = new File[]{new File(String.valueOf(AllTests.ARTIFACT_LOCATION) + this.fSep + "sdd-common-1.0.xsd-NotHere")};
            new SchemaValidationRule(Arrays.asList(files));
            SchemaValidationRule_Test.fail((String)"Schema is missing but a FileNotFoundException was not thrown");
        }
        catch (FileNotFoundException fileNotFoundException) {}
    }

    public void testSchemaValidationRule_ReadableInputStream() throws FileNotFoundException, IOException {
        InputStream[] streams = new InputStream[]{new FileInputStream(new File("sdd_schema/sdd-common-1.0.xsd"))};
        SchemaValidationRule validationRule = new SchemaValidationRule(Arrays.asList(streams));
        SchemaValidationRule_Test.assertNotNull((Object)validationRule);
    }

    public void testSchemaValidationRule_UnreadableInputStream() throws FileNotFoundException, IOException {
        InputStream[] streams = new InputStream[]{new FileInputStream(new File("sdd_schema/sdd-common-1.0.xsd"))};
        streams[0].close();
        try {
            new SchemaValidationRule(Arrays.asList(streams));
            SchemaValidationRule_Test.fail((String)"InputStream is unreadable but an IOException was not thrown");
        }
        catch (IOException iOException) {}
    }

    public void testSchemaValidationRule_AddFromFile() throws FileNotFoundException, IOException {
        SchemaValidationRule validationRule = new SchemaValidationRule(new File("sdd_schema/sdd-packageDescriptor-1.0.xsd"));
        File schemaFile = new File("sdd_schema/sdd-common-1.0.xsd");
        validationRule.addSchemaFile(schemaFile);
        SchemaValidationRule_Test.assertEquals((int)validationRule.getSchemaFiles().size(), (int)2);
        SchemaValidationRule_Test.assertEquals((Object)validationRule.getSchemaFiles().toArray(new File[0])[1], (Object)schemaFile);
    }

    public void testSchemaValidationRule_AddFromInputStream() throws FileNotFoundException, IOException {
        SchemaValidationRule validationRule = new SchemaValidationRule(new File("sdd_schema/sdd-packageDescriptor-1.0.xsd"));
        FileInputStream schemaStream = new FileInputStream(new File("sdd_schema/sdd-common-1.0.xsd"));
        validationRule.addSchemaInputStream(schemaStream);
        SchemaValidationRule_Test.assertEquals((int)validationRule.getSchemaFiles().size(), (int)2);
        SchemaValidationRule_Test.assertEquals((int)validationRule.getSchemaInputStreams().size(), (int)1);
        SchemaValidationRule_Test.assertEquals((Object)validationRule.getSchemaInputStreams().toArray(new InputStream[0])[0], (Object)schemaStream);
    }

    public void testSchemaValidationRule_RemoveFile() throws FileNotFoundException, IOException {
        SchemaValidationRule validationRule = new SchemaValidationRule(new File("sdd_schema/sdd-packageDescriptor-1.0.xsd"));
        File schemaFile = new File("sdd_schema/sdd-common-1.0.xsd");
        validationRule.addSchemaFile(schemaFile);
        validationRule.removeSchemaFile(null);
        SchemaValidationRule_Test.assertEquals((int)validationRule.getSchemaFiles().size(), (int)2);
        validationRule.removeSchemaFile(schemaFile);
        SchemaValidationRule_Test.assertEquals((int)validationRule.getSchemaFiles().size(), (int)1);
    }

    public void testSchemaValidationRule_RemoveInputStream() throws FileNotFoundException, IOException {
        SchemaValidationRule validationRule = new SchemaValidationRule(new File("sdd_schema/sdd-packageDescriptor-1.0.xsd"));
        FileInputStream schemaStream = new FileInputStream(new File("sdd_schema/sdd-common-1.0.xsd"));
        validationRule.addSchemaInputStream(schemaStream);
        validationRule.removeSchemaInputStream(null);
        SchemaValidationRule_Test.assertEquals((int)validationRule.getSchemaFiles().size(), (int)2);
        SchemaValidationRule_Test.assertEquals((int)validationRule.getSchemaInputStreams().size(), (int)1);
        validationRule.removeSchemaInputStream(schemaStream);
        SchemaValidationRule_Test.assertEquals((int)validationRule.getSchemaFiles().size(), (int)1);
        SchemaValidationRule_Test.assertEquals((int)validationRule.getSchemaInputStreams().size(), (int)0);
    }

    public void testValidate_ValidDD() throws FileNotFoundException, IOException {
        File[] files = new File[]{new File("sdd_schema/sdd-common-1.0.xsd"), new File("sdd_schema/sdd-deploymentDescriptor-1.0.xsd")};
        SchemaValidationRule validationRule = new SchemaValidationRule(Arrays.asList(files));
        File xmlFile = new File(AllTests.VALID_DD);
        SchemaValidationRule_Test.assertEquals((int)validationRule.validate(new FileInputStream(xmlFile)).size(), (int)0);
    }

    public void testValidate_ValidPD() throws FileNotFoundException, IOException {
        File[] files = new File[]{new File("sdd_schema/sdd-common-1.0.xsd"), new File("sdd_schema/xmldsig-core-schema.xsd"), new File("sdd_schema/sdd-packageDescriptor-1.0.xsd")};
        SchemaValidationRule validationRule = new SchemaValidationRule(Arrays.asList(files));
        File xmlFile = new File(AllTests.VALID_PD);
        SchemaValidationRule_Test.assertEquals((int)validationRule.validate(new FileInputStream(xmlFile)).size(), (int)0);
    }

    public void testValidate_InvalidDD() throws FileNotFoundException, IOException {
        File xmlFile;
        File[] files = new File[]{new File("sdd_schema/sdd-common-1.0.xsd"), new File("sdd_schema/sdd-deploymentDescriptor-1.0.xsd")};
        SchemaValidationRule validationRule = new SchemaValidationRule(Arrays.asList(files));
        Collection<XMLValidationError> validationErrors = validationRule.validate(new FileInputStream(xmlFile = new File(AllTests.INVALID_DD)));
        SchemaValidationRule_Test.assertFalse((validationErrors.size() == 0 ? 1 : 0) != 0);
    }

    public void testValidate_InvalidPD() throws FileNotFoundException, IOException {
        File xmlFile;
        File[] files = new File[]{new File("sdd_schema/sdd-common-1.0.xsd"), new File("sdd_schema/xmldsig-core-schema.xsd"), new File("sdd_schema/sdd-packageDescriptor-1.0.xsd")};
        SchemaValidationRule validationRule = new SchemaValidationRule(Arrays.asList(files));
        Collection<XMLValidationError> validationErrors = validationRule.validate(new FileInputStream(xmlFile = new File(AllTests.INVALID_PD)));
        SchemaValidationRule_Test.assertFalse((validationErrors.size() == 0 ? 1 : 0) != 0);
    }

    public void testError() throws FileNotFoundException, IOException {
        File[] files = new File[]{new File("sdd_schema/sdd-common-1.0.xsd")};
        SchemaValidationRule validationRule = new SchemaValidationRule(Arrays.asList(files));
        validationRule.error(new SAXParseException("Test exception - error()", "publicId", "systemId", 0, 0));
    }

    public void testFatalError() throws FileNotFoundException, IOException {
        File[] files = new File[]{new File("sdd_schema/sdd-common-1.0.xsd")};
        SchemaValidationRule validationRule = new SchemaValidationRule(Arrays.asList(files));
        validationRule.fatalError(new SAXParseException("Test exception - fatalError()", "publicId", "systemId", 0, 0));
    }

    public void testWarning() throws FileNotFoundException, IOException {
        File[] files = new File[]{new File("sdd_schema/sdd-common-1.0.xsd")};
        SchemaValidationRule validationRule = new SchemaValidationRule(Arrays.asList(files));
        validationRule.warning(new SAXParseException("Test exception - warning()", "publicId", "systemId", 0, 0));
    }
}

