/***********************************************************************
 * Copyright (c) 2009 CA, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     CA, Inc. - Initial implementation
 ***********************************************************************/
package org.eclipse.cosmos.me.sdd.schema.ext;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlValue;

public class Variable {
	private String id;
	private Boolean parameter;
	private Boolean required;
	private String defaultValue;
	private String value;
	
	public Variable() { }
	
	public Variable(String name, String value) {
		this.id = name;
		this.value = value;
	}

	@XmlAttribute
	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	@XmlValue
	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		if (value != null && value.trim().equals("")) {
			this.value =  null;
		} else {
			this.value = value;
		}
	}

	@XmlAttribute
	public Boolean isParameter() {
		if (parameter == null) return Boolean.FALSE;
		return parameter;
	}

	public void setParameter(Boolean parameter) {
		this.parameter = parameter;
	}

	@XmlAttribute
	public String getDefaultValue() {
		return defaultValue;
	}

	public void setDefaultValue(String defaultValue) {
		this.defaultValue = defaultValue;
	}

	@XmlAttribute
	public Boolean isRequired() {
		if (required == null) {
			if (isParameter() && getDefaultValue() == null) {
				return Boolean.TRUE;
			} else {
				return Boolean.FALSE;
			}
		}
		return required;
	}

	public void setRequired(Boolean required) {
		this.required = required;
	}
	
	
}
