package org.eclipse.cosmos.me.sdd.tooling.btg.aggregator.comparisons;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

import org.eclipse.cosmos.me.sdd.schema.BoundaryType;
import org.eclipse.cosmos.me.sdd.schema.IntegerParameterType;

public class IntegerParameterCompare
{

	protected static Collection<IntegerParameterType> merge(Vector<IntegerParameterType> ints1,	Vector<IntegerParameterType> ints2)
	{
		Vector <IntegerParameterType> paramsToRemove = new Vector <IntegerParameterType> ();
		Iterator <IntegerParameterType> paramIter1 = ints1.iterator();		
		//iterate through the params
		while (paramIter1.hasNext())
		{
			IntegerParameterType param1 = (IntegerParameterType) paramIter1.next();
			Iterator <IntegerParameterType> paramIter2 = ints2.iterator();
			while (paramIter2.hasNext())
			{
				IntegerParameterType param2 = (IntegerParameterType) paramIter2.next();
				//if you find a match that hasn't been found, note it
				//one of the equals needs to be deleted with its children merged over
				if (paramsToRemove.contains(param2)==false)
				{
					if (equals(param1, param2))
					{  
						//merge hosted resources, types and description groups
						paramsToRemove.add(param2);
						Vector<BoundaryType> bounds = BoundaryCompare.merge(param1.getBounds(),param2.getBounds());
						param1.getBounds().clear();
						param1.getBounds().addAll(bounds);
					}
				}
					
			}
		}
		
		ints2.removeAll(paramsToRemove);
		//remove all of the matches that were found
		
		Vector <IntegerParameterType> finalParams = new Vector <IntegerParameterType> ();
		//create and return a new collection with all of the remaining items
		finalParams.addAll(ints1);
		finalParams.addAll(ints2);		
		
		return finalParams;
		
	}	
	
	protected static boolean equals(IntegerParameterType int1, IntegerParameterType int2)
	{	
		if (!StringCompare.equals(int1.getDefaultValue(),int2.getDefaultValue()))
			return false;
		if (int1.isSensitive()!=int2.isSensitive())
			return false;
		if (int1.isRequired()!=int2.isRequired())
			return false;
		if (OperationCompare.equals(int1.getOperation(),int2.getOperation()))
			return false;
		return true;
	}

}