/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.dmtoolkit.j2ee.delegates;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.cosmos.me.internal.dmtoolkit.common.artifacts.interfaces.IProjectConfig;
import org.eclipse.cosmos.me.internal.dmtoolkit.common.util.Utilities;
import org.eclipse.cosmos.me.internal.dmtoolkit.j2ee.DMJ2EEPlugin;
import org.eclipse.cosmos.me.internal.dmtoolkit.j2ee.Messages;
import org.eclipse.cosmos.me.internal.dmtoolkit.j2ee.util.J2EEUtilities;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IDelegate;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataManagerFacetInstallDelegate
implements IDelegate {
    private static final String NAME_PROPERTY_NAME = "name";
    private static final String PACKAGE_PROPERTY_NAME = "package";
    private static final String METADATA_FILE_NAME = ".metadata";
    private static final String RESOURCES_FOLDER = "resources/";
    private IProjectConfig config;

    public void execute(IProject project, IProjectFacetVersion fv, Object config, IProgressMonitor monitor) throws CoreException {
        this.setConfig((IProjectConfig)config, project);
        monitor.beginTask(Messages.dataManagerFacetInstallDelegateProgressMonitorStatusMessage, this.taskCount());
        try {
            if (this.getConfig().isRegistrationServiceConfig()) {
                this.adjustRegistrationConfig(project);
            } else {
                this.saveQueryServiceProperties(project, monitor);
            }
            this.copyBundles(project, monitor);
            this.copyBundleContents(project, monitor);
            this.copyResources(project, monitor);
            this.createServiceGroupClass(project, monitor);
            this.getConfig().createSupportCode();
            this.populateServicesDir(project, monitor);
        }
        finally {
            monitor.done();
        }
    }

    protected void saveQueryServiceProperties(IProject project, IProgressMonitor monitor) throws CoreException {
        Properties props = new Properties();
        props.put(NAME_PROPERTY_NAME, this.getConfig().getName());
        props.put(PACKAGE_PROPERTY_NAME, this.getConfig().getPackageName());
        IFile metadata = project.getFile(METADATA_FILE_NAME);
        try {
            FileOutputStream stream = new FileOutputStream(metadata.getLocation().toFile());
            props.store(stream, Messages.dataManagerFacetInstallDelegateMetadataFileComment);
        }
        catch (IOException e) {
            throw DMJ2EEPlugin.createCoreException(e);
        }
        metadata.refreshLocal(1, monitor);
    }

    protected void adjustRegistrationConfig(IProject project) throws CoreException {
        IFile metadata = project.getFile(METADATA_FILE_NAME);
        try {
            FileInputStream stream = new FileInputStream(metadata.getLocation().toFile());
            Properties props = new Properties();
            props.load(stream);
            this.getConfig().setName(props.getProperty(NAME_PROPERTY_NAME));
            this.getConfig().setPackageName(props.getProperty(PACKAGE_PROPERTY_NAME));
        }
        catch (IOException e) {
            throw DMJ2EEPlugin.createCoreException(e);
        }
    }

    protected void populateServicesDir(IProject project, IProgressMonitor monitor) throws CoreException {
        IFolder metaInfDir;
        String dataManagerName = this.getConfig().getName();
        IFolder servicesDir = J2EEUtilities.getWebInfServicesDir(project);
        IFolder dataManagerDir = servicesDir.getFolder(dataManagerName);
        if (!dataManagerDir.exists()) {
            dataManagerDir.create(true, true, monitor);
        }
        if (!(metaInfDir = dataManagerDir.getFolder("META-INF")).exists()) {
            metaInfDir.create(true, true, monitor);
        }
        this.copyWsdls(metaInfDir, monitor);
        this.copyDatamodel(metaInfDir, monitor);
        this.createServicesXml(metaInfDir, monitor);
        this.createCosmosProperties(metaInfDir, monitor);
    }

    protected void copyDatamodel(IFolder metaInfDir, IProgressMonitor monitor) throws CoreException {
        Bundle bundle = DMJ2EEPlugin.getDefault().getBundle();
        J2EEUtilities.copyFromPlugin(bundle, (IPath)new Path("resources/cmdbfDatamodel.xsd"), metaInfDir);
        monitor.worked(1);
    }

    protected void createCosmosProperties(IFolder metaInfDir, IProgressMonitor monitor) throws CoreException {
        File propsFile = metaInfDir.getLocation().append("cosmos.properties").toFile();
        String cosmosPropertiesContents = null;
        PrintWriter pw = null;
        try {
            try {
                if (propsFile.exists()) {
                    cosmosPropertiesContents = this.getFileContentsAsString(propsFile);
                } else {
                    String[] substitutionMap = new String[]{"%DISPLAY_NAME%", this.getConfig().getName()};
                    cosmosPropertiesContents = J2EEUtilities.populateResourceTemplate(substitutionMap, "resources/cosmosPropertiesTemplate.txt");
                }
                pw = new PrintWriter(new FileWriter(propsFile));
                pw.write(cosmosPropertiesContents);
            }
            catch (FileNotFoundException e) {
                throw DataManagerFacetInstallDelegate.createCoreException(e);
            }
            catch (IOException e) {
                throw DataManagerFacetInstallDelegate.createCoreException(e);
            }
        }
        finally {
            pw.close();
        }
        IFile file = metaInfDir.getFile("cosmos.properties");
        file.refreshLocal(1, monitor);
        monitor.worked(1);
    }

    protected void createServicesXml(IFolder metaInfDir, IProgressMonitor monitor) throws CoreException {
        File propsFile = metaInfDir.getLocation().append("services.xml").toFile();
        String servicesXmlContents = null;
        PrintWriter pw = null;
        try {
            try {
                if (propsFile.exists()) {
                    servicesXmlContents = this.getFileContentsAsString(propsFile);
                } else {
                    String[] substitutionMap = new String[]{"%DATA_MANAGER_NAME%", this.getConfig().getName()};
                    servicesXmlContents = J2EEUtilities.populateResourceTemplate(substitutionMap, "resources/servicesXmlTemplate.txt");
                }
                servicesXmlContents = servicesXmlContents.replace("</serviceGroup>", String.valueOf(this.getOtherServicesString()) + "</serviceGroup>");
                pw = new PrintWriter(new FileWriter(propsFile));
                pw.write(servicesXmlContents);
            }
            catch (FileNotFoundException e) {
                throw DataManagerFacetInstallDelegate.createCoreException(e);
            }
            catch (IOException e) {
                throw DataManagerFacetInstallDelegate.createCoreException(e);
            }
        }
        finally {
            pw.close();
        }
        IFile file = metaInfDir.getFile("services.xml");
        file.refreshLocal(1, monitor);
        monitor.worked(1);
    }

    protected String getFileContentsAsString(File propsFile) throws FileNotFoundException, IOException {
        BufferedReader reader = new BufferedReader(new FileReader(propsFile));
        String line = null;
        StringWriter writer = new StringWriter();
        while ((line = reader.readLine()) != null) {
            writer.write(String.valueOf(line) + "\n");
        }
        writer.close();
        reader.close();
        String servicesXmlContents = writer.toString();
        return servicesXmlContents;
    }

    protected String getOtherServicesString() throws CoreException {
        StringWriter writer = new StringWriter();
        String[] substitutionMap = new String[]{"%DATA_MANAGER_NAME%", this.getConfig().getName(), "%FULLY_QUALIFIED_SERVICE_CLASS%", this.getFullyQualifiedClassName()};
        String fileContents = J2EEUtilities.populateResourceTemplate(substitutionMap, RESOURCES_FOLDER + this.getServiceTemplateFileName());
        writer.append(String.valueOf(fileContents) + "\n");
        return writer.toString();
    }

    protected String getFullyQualifiedClassName() {
        return String.valueOf(this.getConfig().getPackageName()) + "." + this.getConfig().getGeneratedClassName();
    }

    protected String getServiceTemplateFileName() {
        if (this.getConfig().isQueryServiceConfig()) {
            return "servicesXmlQueryTemplate.txt";
        }
        return "servicesXmlRegistrationTemplate.txt";
    }

    protected void copyWsdls(IFolder metaInfDir, IProgressMonitor monitor) throws CoreException {
        List bundleList = this.getConfig().getWsdlFilesToCopy();
        Iterator iterator = bundleList.iterator();
        Bundle bundle = DMJ2EEPlugin.getDefault().getBundle();
        while (iterator.hasNext()) {
            block6: {
                String fileName = (String)iterator.next();
                Path sourceFile = new Path(RESOURCES_FOLDER + fileName);
                try {
                    IFile destFile = metaInfDir.getFile(sourceFile.lastSegment());
                    if (destFile.exists()) break block6;
                    InputStream in = FileLocator.openStream((Bundle)bundle, (IPath)sourceFile, (boolean)false);
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                    String line = null;
                    StringWriter writer = new StringWriter();
                    while ((line = reader.readLine()) != null) {
                        String newLine = line.replace("%SERVICE_NAME%", this.getConfig().getGeneratedClassName());
                        writer.write(String.valueOf(newLine) + "\n");
                    }
                    try {
                        writer.close();
                        reader.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    FileWriter fileForRewrite = new FileWriter(destFile.getLocation().toOSString());
                    fileForRewrite.write(writer.toString());
                    fileForRewrite.close();
                    destFile.refreshLocal(1, monitor);
                }
                catch (IOException e) {
                    throw DMJ2EEPlugin.createCoreException(e);
                }
            }
            monitor.worked(1);
        }
    }

    protected static String readLine(BufferedReader reader) throws CoreException {
        String line = null;
        try {
            line = reader.readLine();
        }
        catch (IOException e) {
            throw DataManagerFacetInstallDelegate.createCoreException(e);
        }
        return line;
    }

    protected static CoreException createCoreException(Exception e) {
        return new CoreException(DMJ2EEPlugin.createErrorStatus(e.getMessage(), e));
    }

    protected void createServiceGroupClass(IProject project, IProgressMonitor monitor) throws CoreException {
        Utilities.createServiceGroupClass((IProject)project, (IProjectConfig)this.getConfig(), (IProgressMonitor)monitor);
    }

    protected int taskCount() {
        return this.fileCount() + 3;
    }

    protected void copyBundles(IProject project, IProgressMonitor monitor) throws CoreException {
        for (String bundleName : this.getBundlesToCopy()) {
            IFolder webInfLib = J2EEUtilities.getWebInfLibDir(project);
            J2EEUtilities.copyBundle(bundleName, webInfLib);
            monitor.worked(1);
        }
    }

    protected void copyResources(IProject project, IProgressMonitor monitor) throws CoreException {
        Bundle bundle = DMJ2EEPlugin.getDefault().getBundle();
        IFolder webInfLib = J2EEUtilities.getWebInfLibDir(project);
        for (String fileName : this.getResourcesToCopy()) {
            J2EEUtilities.copyFromPlugin(bundle, (IPath)new Path(fileName), webInfLib);
            monitor.worked(1);
        }
    }

    protected void copyBundleContents(IProject project, IProgressMonitor monitor) throws CoreException {
        IFolder webInfLib = J2EEUtilities.getWebInfLibDir(project);
        HashMap<String, String> bundleMap = this.getBundleContentsToCopy();
        for (String jarFileName : bundleMap.keySet()) {
            String symbolicName = (String)bundleMap.get(jarFileName);
            Bundle bundle = Platform.getBundle((String)symbolicName);
            if (bundle == null) {
                throw new CoreException(DMJ2EEPlugin.createErrorStatus(NLS.bind((String)Messages.dataManagerFacetInstallDelegateErrorMissingRequiredBundle, (Object)symbolicName)));
            }
            J2EEUtilities.copyFromPlugin(bundle, (IPath)new Path(jarFileName), webInfLib);
            monitor.worked(1);
        }
    }

    protected int fileCount() {
        return this.getBundlesToCopy().size() + this.getResourcesToCopy().size() + this.getBundleContentsToCopy().size() + this.getConfig().getWsdlFilesToCopy().size();
    }

    protected ArrayList<String> getBundlesToCopy() {
        String[] bundleList = new String[]{"org.eclipse.cosmos.common"};
        return new ArrayList<String>(Arrays.asList(bundleList));
    }

    protected ArrayList<String> getResourcesToCopy() {
        String[] resourceList = new String[]{};
        return new ArrayList<String>(Arrays.asList(resourceList));
    }

    protected HashMap<String, String> getBundleContentsToCopy() {
        HashMap<String, String> dmList = new HashMap<String, String>();
        String[] bundleList = new String[]{"CMDBfCommon.jar", "org.eclipse.cosmos.dc.cmdbf.services", "CMDBfQueryTransformation.jar", "org.eclipse.cosmos.dc.cmdbf.services", "CMDBfQueryService.jar", "org.eclipse.cosmos.dc.cmdbf.services", "cmdbf-ws.jar", "org.eclipse.cosmos.dc.cmdbf", "datamanager-ws.jar", "org.eclipse.cosmos.dc.datamanager"};
        int i = 0;
        while (i < bundleList.length) {
            dmList.put(bundleList[i], bundleList[i + 1]);
            i += 2;
        }
        if (this.getConfig().isRegistrationServiceConfig()) {
            dmList.put("CMDBfRegistrationService.jar", "org.eclipse.cosmos.dc.cmdbf.services");
            dmList.put("CMDBfRegistrationTransformation.jar", "org.eclipse.cosmos.dc.cmdbf.services");
            dmList.put("CMDBfMetadata.jar", "org.eclipse.cosmos.dc.cmdbf.services");
        }
        return dmList;
    }

    public IProjectConfig getConfig() {
        return this.config;
    }

    public void setConfig(IProjectConfig config, IProject project) {
        this.config = config;
        config.setProject(project);
    }
}

