/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.internal.dr.drs.service.outputter;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ReportElement
implements Serializable {
    private static final long serialVersionUID = 7713301965312164326L;
    protected Map<String, String> metadata = new HashMap<String, String>();
    protected Element elem;
    protected Element localId;
    protected Element filename;

    public ReportElement(Element elem) {
        this.elem = elem;
        NodeList list = elem.getElementsByTagName("visualizationId");
        if (list.getLength() > 0) {
            Element visualizationId = (Element)list.item(0);
            if ((list = visualizationId.getElementsByTagName("localId")).getLength() > 0) {
                this.localId = (Element)list.item(0);
            }
            if ((list = visualizationId.getElementsByTagName("filename")).getLength() > 0) {
                this.filename = (Element)list.item(0);
            }
        }
        if ((list = elem.getElementsByTagName("visualizationDescription")).getLength() > 0) {
            Element visualizationDescription = (Element)list.item(0);
            list = visualizationDescription.getChildNodes();
            int x = 0;
            while (x < list.getLength()) {
                if (list.item(x).getNodeType() == 1) {
                    Element property = (Element)list.item(x);
                    this.metadata.put(property.getTagName(), property.getTextContent());
                }
                ++x;
            }
        }
    }

    public String getMetaData(String key) {
        return this.metadata.get(key);
    }

    public void putMetaData(String key, String value) {
        this.metadata.put(key, value);
    }

    public String getId() {
        return this.localId.getTextContent();
    }

    public String getFilename() {
        return this.filename.getTextContent();
    }
}

