/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.me.internal.dmtoolkit.j2ee.factory;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.cosmos.me.internal.dmtoolkit.common.artifacts.interfaces.IProjectConfig;
import org.eclipse.cosmos.me.internal.dmtoolkit.common.artifacts.interfaces.ToolkitArtifactFactory;
import org.eclipse.wst.common.project.facet.core.IActionConfigFactory;

/**
 * Factory required by facet framework to return instance of wizard page model object
 * for projects implementing a registration service
 * 
 * @author David Whiteman
 */
public class RegistrationServiceFacetInstallConfigFactory implements
		IActionConfigFactory {

	public Object create() throws CoreException {
		return ToolkitArtifactFactory.createProjectConfig(IProjectConfig.REGISTRATION_SERVICE);
	}

}
