/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.deregistration.transform.input.artifacts;

import org.eclipse.cosmos.dc.internal.cmdbf.services.deregistration.transform.input.artifacts.DeregisterRequest;
import org.eclipse.cosmos.dc.internal.cmdbf.services.transform.artifacts.CommonArtifactFactory;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.input.artifacts.IItemList;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.input.artifacts.IRelationshipList;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.registration.transform.input.artifacts.RegisterInputArtifactFactory;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IInstanceId;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IItem;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IRelationship;

/**
 * Factory for creating elements in the deregister request POJO graph
 * 
 * 
 * @author David Whiteman
 */
public class DeregisterInputArtifactFactory implements IDeregisterInputArtifactFactory {

	private static IDeregisterInputArtifactFactory instance;

	public static IDeregisterInputArtifactFactory getInstance() {
		if (instance == null) {
			instance = new DeregisterInputArtifactFactory();
		}

		return instance;
	}
	
	/*
	 * Answer a new instance of an {@link IDeregisterRequest}
	 * 
	 * @return
	 */
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.deregistration.transform.input.artifacts.IDeregisterInputArtifactFactory#createDeregisterRequest()
	 */
	public IDeregisterRequest createDeregisterRequest() {
		return new DeregisterRequest();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.deregistration.transform.input.artifacts.IDeregisterInputArtifactFactory#createItemList()
	 */
	public IItemList createItemList() 
	{
		return RegisterInputArtifactFactory.getInstance().createItemList(true);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.deregistration.transform.input.artifacts.IDeregisterInputArtifactFactory#createRelationshipList()
	 */
	public IRelationshipList createRelationshipList() {
		return RegisterInputArtifactFactory.getInstance().createRelationshipList(true);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.deregistration.transform.input.artifacts.IDeregisterInputArtifactFactory#createInstanceId(java.lang.String, java.lang.String)
	 */
	public IInstanceId createInstanceId(String mdrId, String localId) {
		return CommonArtifactFactory.getInstance().createInstanceId(mdrId, localId);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.deregistration.transform.input.artifacts.IDeregisterInputArtifactFactory#createItem()
	 */
	public IItem createItem()
	{
		return RegisterInputArtifactFactory.getInstance().createItem();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.cosmos.dc.provisional.cmdbf.services.deregistration.transform.input.artifacts.IDeregisterInputArtifactFactory#createRelationship()
	 */
	public IRelationship createRelationship()
	{
		return RegisterInputArtifactFactory.getInstance().createRelationship();
	}

	public IInstanceId createInstanceId() {
		return CommonArtifactFactory.getInstance().createInstanceId();
	}


}
