/**********************************************************************
 * Copyright (c) 2007 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * IBM - Initial API and implementation
 *
 * $Id: SessionResolveFixedTreeIDs.java,v 1.2 2008/01/08 21:43:06 sleeloy Exp $
 **********************************************************************/
package org.eclipse.cosmos.internal.dr.drs.service.handler.common;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpSession;

import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.IIDResolver;

public class SessionResolveFixedTreeIDs implements IIDResolver {

	public static Map resourceLookup;	
	protected static int counter; 
	
	public SessionResolveFixedTreeIDs(){
		counter = 1;
		if (resourceLookup == null){
			resourceLookup = new HashMap();
		}
		
	}
	public SessionResolveFixedTreeIDs(HttpSession session){
		this();
	}
	public Object getId(Object value) {
		Object id = resourceLookup.get(value);
		if (id == null){
			counter++;
			id = "" + counter; //$NON-NLS-1$
			resourceLookup.put(id, value);
		}	
		return id;
	}
	
	public void clear() {
		if (resourceLookup != null)
			resourceLookup.clear();		
	}	

}
