/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.transform;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.IRootElement;

/**
 * Interface for any SAX parser handler used by the query service and
 * registration service XML input transformers.  The root object in the
 * object graph created by the handler must be returned by getResult() and
 * implement the IRootElement interface.
 * 
 * 
 * @author David Whiteman
 */
public interface ITransformerHandler {
	/**
	 * Answers the resulting topmost object in the object graph created by parsing 
	 * the input XML
	 * 
	 * @return
	 */
	public IRootElement getResult();
}
