/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dr.internal.web.ui;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MDRInputDialog extends Dialog {
	  private String name;
	  private String epr;
	  protected Text textEPR; 
	  protected Text text;

	  public MDRInputDialog(IShellProvider parentShell) {
		super(parentShell);
	}


	public MDRInputDialog(Shell parentShell) {
		super(parentShell);
	}



	  @Override
	protected Control createDialogArea(Composite parent) {
		  final Composite composite = (Composite)super.createDialogArea(parent); 
		// TODO Auto-generated method stub
		    composite.setLayout(new GridLayout(2, true));

		    // Show the message
		    Label label = new Label(composite, SWT.NONE);
		    label.setText(Messages.getString("MDRInputDialog.0"));  //$NON-NLS-1$
		    GridData data = new GridData();
		    data.horizontalSpan = 1;
		    data.heightHint = 20;
		    label.setLayoutData(data);

		    // Display the input box
		    text = new Text(composite, SWT.BORDER);
		    text.setText(Messages.getString("MDRInputDialog.1"));  //$NON-NLS-1$
		    data = new GridData(GridData.FILL_HORIZONTAL);
		    data.horizontalSpan = 1;
		    data.heightHint = 20;
		    data.widthHint = 120;
		    text.setLayoutData(data);

		    Label labelEPR = new Label(composite, SWT.NONE);
		    labelEPR.setText(Messages.getString("MDRInputDialog.2"));  //$NON-NLS-1$
		    GridData dataEPR = new GridData();
		    dataEPR.horizontalSpan = 1;
		    labelEPR.setLayoutData(data);

		    // Display the input box
		    textEPR = new Text(composite, SWT.BORDER);
		    dataEPR = new GridData(GridData.FILL_HORIZONTAL);
		    dataEPR.horizontalSpan = 1;
		    textEPR.setLayoutData(dataEPR);
		return composite;
	}

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
       
		shell.setText( Messages.getString("MDRInputDialog.3"));  //$NON-NLS-1$
    }


	@Override
	protected void okPressed() {
        name = text.getText();
        epr = textEPR.getText();
		super.okPressed();
	}


	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getEpr() {
		return epr;
	}

	public void setEpr(String epr) {
		this.epr = epr;
	}	  
	}
	           