/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.me.internal.dmtoolkit.common.artifacts;


import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.cosmos.me.internal.dmtoolkit.common.Messages;
import org.eclipse.cosmos.me.internal.dmtoolkit.common.artifacts.interfaces.IDMToolkitConstants;
import org.eclipse.cosmos.me.internal.dmtoolkit.common.util.Utilities;


/**
 * Describes the properties of the query service implementation.
 * 
 * @author David Whiteman
 */
public class QueryServiceProjectConfig extends AbstractProjectConfig {

	private static final String PACKAGE_QUALIFIER_SEPARATOR = ".";
	private static final String QUERY_HANDLER_FACTORY = "QueryHandlerFactory";

	@Override
	protected String getParentClassNameFull() {
		return IDMToolkitConstants.PARENT_CLASS_QUERY_SERVICE; //$NON-NLS-1$
	}

	@Override
	public String getProjectTypeName() {
		// TODO is this needed anymore?
		return Messages.projectConfigMDRType;
	}

	@Override
	protected String defaultDataManagerName() {
		return Messages.projectConfigMDRClassNameDefault;
	}

	@Override
	public String getClassSource() throws CoreException {
		String[] substitutionMap = {
				"%PACKAGE_NAME%", getPackageName(),
				"%EXTRA_IMPORTS%", getServiceSpecificImports(),
				"%MDR_CLASS%", getGeneratedClassName(),
				"%SERVICE_SPECIFIC_CODE%", getServiceSpecificSource(),
				"%ABSTRACT_PARENT_CLASS_FULL%", getParentClassNameFull(),
				"%ABSTRACT_PARENT_CLASS%", getParentClassName(),
				"%OPERATION_INITS%", getOperationInits()
		};
		String resourceLocation = IDMToolkitConstants.RESOURCES_MDR_TEMPLATE;
		return Utilities.populateResourceTemplate(substitutionMap, resourceLocation);
	}
	
	public String getServiceSpecificImports() throws CoreException {
		return Utilities.populateResourceTemplate(new String[] {"%QUERY_HANDLER_FULL_CLASS_NAME%", getHandlerPackageName()+PACKAGE_QUALIFIER_SEPARATOR+QUERY_HANDLER_FACTORY}, "resources/queryServiceImports.txt");
	}
	
	public List<String> getWsdlFilesToCopy() {
		List<String> dmList = new ArrayList<String>();
		dmList.add(IDMToolkitConstants.QUERY_SERVICE_WSDL); 
		dmList.add(IDMToolkitConstants.CMDBF_QUERY_WSDL);
		return dmList;
	}

	@Override
	public boolean isQueryServiceConfig() {
		return true;
	}
	
	protected String getOperationInits() {
		StringWriter writer = new StringWriter();
		writer.write("\n\t\tgetQueryOperation().initialize(init);");
		return writer.toString();
	}

	@Override
	public String getGeneratedClassName() {
		return getName() + IDMToolkitConstants.SUFFIX_SERVICE_QUERY;
	}
	
	public String getServiceSpecificSource() throws CoreException {
		return Utilities.populateResourceTemplate(new String[] {"%QUERY_HANDLER_FACTORY_NAME%", QUERY_HANDLER_FACTORY}, "resources/queryServiceMethods.txt");
	}

	@Override
	public void createSupportCode() throws CoreException {
		Utilities.createProjectClass(getProject(), this, null, Utilities.populateResourceTemplate(new String[] {"%PACKAGE_NAME%", getHandlerPackageName(), "%CLASS_NAME%", QUERY_HANDLER_FACTORY}, "resources/queryServiceHandlerFactory.txt"), QUERY_HANDLER_FACTORY, getHandlerPackageName());
	}

	private String getHandlerPackageName() {
		return getPackageName()+".handlers";
	}
}
