/**********************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation.
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * IBM - Initial API and implementation
 **********************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.query.service;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.cmdbfservice.IQueryHandler;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.CMDBfServiceException;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.input.artifacts.IRelationshipTemplate;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.IEdges;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.query.transform.response.artifacts.IQueryResult;
import org.eclipse.cosmos.dc.provisional.cmdbf.services.transform.artifacts.IItem;


/**
 * This type of handler is used to process a relationship template
 * in a CMDBf query request.  A relationship handler will typically include
 * all edges satisfying the source, target, and depth limit of the template. 
 * Successive processing of the template's constraints will further narrow
 * down the result. 
 * 
 * 
 * @author Ali Mehregani
 */
public interface IRelationshipTemplateHandler extends IQueryHandler
{
	/**
	 * Execute this relationship template handler based on the relationship
	 * argument passed in.
	 * 
	 * @param context The context to work from
	 * @param relationshipTemplate The relationship template
	 * @param source The source of the relationship
	 * @param target The target of the relationship
	 * 
	 * @return The edges that are representative of processing this relationship template
	 * @throws CMDBfServiceException In case of any unexpected error
	 */
	public IEdges execute(IQueryResult context, IRelationshipTemplate relationshipTemplate, IItem source, IItem target) throws CMDBfServiceException;
}
