/***********************************************************************
 * Copyright (c) 2009 SAS Institute, Inc. and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute, Inc. - initial API and implementation
 ***********************************************************************/
package org.eclipse.cosmos.me.sdd.profile.cim;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import javax.xml.namespace.QName;

public class DatabaseSystemType {

	protected static final QName NAME = new QName(
			"http://docs.oasis-open.org/sdd/ns/cim-profile",
			"CIM_DatabaseSystem.Name");
	protected static final QName STATUS = new QName(
			"http://docs.oasis-open.org/sdd/ns/cim-profile",
			"CIM_DatabaseSystem.Status");
	protected static final QName PORT = new QName(
			"http://docs.oasis-open.org/sdd/ns/cim-profile",
			"CIM_DatabaseSystem.Port");
	protected static final QName VERSION = new QName(
			"http://docs.oasis-open.org/sdd/ns/cim-profile",
			"CIM_DatabaseSystem.Version");

	protected static String NAME_VALUE = null;
	protected static String STATUS_VALUE = null;
	protected static String PORT_VALUE = null;
	protected static String VERSION_VALUE = null;

	protected static final String UNIX_1 = "{0}/{1}/{2}"; // vendor/product/version
	protected static final String UNIX_2 = "{1}/{2}"; // product/version
	protected static final String UNIX_3 = "{1}-{2}"; // product-version
	protected static final String UNIX_4 = "{0}/{1}{2}"; // vendor/productversion
	protected static final String UNIX_5 = "{0}/{1}-{2}"; // vendor/product-version
	protected static final String UNIX_6 = "{1}{2}"; // productversion

	protected static String[] unixRoots = new String[] { "/opt/", "/usr/local/" };
	protected static String[] unixPatterns = new String[] { UNIX_1, UNIX_2, UNIX_3,
			UNIX_4, UNIX_5, UNIX_6 };

	protected static final Pattern PATTERN_LS = Pattern.compile("/[\\w.*]+");
	protected static final String CMD_LS = "ls -d {0}";


	protected static String getCurrentPath() {
		URL url = DatabaseSystemType.class.getProtectionDomain().getCodeSource()
				.getLocation();

		// Remove %20's from url
		File file = null;
		try {
			file = new File(URLDecoder.decode(url.getFile(), "UTF-8"));
		} catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}

		file = file.getParentFile();
		return (file.getAbsolutePath());
	}

	protected static String unixFind(String path) {
		for (int i = 0; i < unixRoots.length; i++) {
			String s = runCommand(MessageFormat.format(CMD_LS, unixRoots[i] + path));

			// Make sure we got something.
			if (s != null) {
				Matcher m = PATTERN_LS.matcher(s);
				if (m.find()) {
					return unixRoots[i] + path;
				}
			}
		}
		return null;
	}

	protected static String runCommand(String command) {
		StringBuffer output = new StringBuffer();
		try {
			// Run the command.
			Runtime runtime = Runtime.getRuntime();
			Process process = runtime.exec(command);
			if (process == null) {
				return null;
			}

			// Read the output of the command.
			BufferedReader inStream = new BufferedReader(new InputStreamReader(
					process.getInputStream()));
			String line = null;

			while ((line = inStream.readLine()) != null) {
				output.append(line).append("\n");
			}
		} catch (Exception e) {
			return null;
		}

		return output.toString();

	}

	protected static String runCommand(String command[]) {
		StringBuffer output = new StringBuffer();
		try {
			// Run the command.
			Runtime runtime = Runtime.getRuntime();
			Process process = runtime.exec(command);
			if (process == null) {
				return null;
			}

			// Read the output of the command.
			BufferedReader inStream = new BufferedReader(new InputStreamReader(
					process.getInputStream()));
			String line = null;

			while ((line = inStream.readLine()) != null) {
				output.append(line).append("\n");
			}
		} catch (Exception e) {
			return null;
		}

		return output.toString();

	}

}
