/**********************************************************************
 * Copyright (c) 2008 CA Inc. and others
 * All rights reserved.   This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors: 
 * CA - Initial API and implementation
 * IBM - provisional API change, removed IRootElement
 **********************************************************************/
package org.eclipse.cosmos.dc.provisional.cmdbf.services.metadata.transform.input.artifacts;

import org.eclipse.cosmos.dc.provisional.cmdbf.services.common.IXMLWritable;

/**
 * Represents a <recordTypes> element in XML form
 * 
 * 
 * @author Bill Muldoon
 */
public interface IRecordTypes extends IXMLWritable
{
	/**
	 * set the namespace 
	 * 
	 * @param namespace
	 */
	public void setNamespace(String namespace);
		
	/**
	 * Retrieve the namespace
	 * 
	 * @return namespace
	 */
	public String getNamespace();

	
	/**
	 * set the schemaLocation 
	 * 
	 * @param schemaLocation
	 */
	public void setSchemaLocation(String schemaLocation);
		
	/**
	 * Retrieve the schemaLocation
	 * 
	 * @return schemaLocation
	 */
	public String getSchemaLocation();

	
	
	/**
	 * add a recordType
	 * 
	 * @param recordType
	 */
	public void addRecordType(IRecordType recordType);
	
	/**
	 * get a collection of recordType
	 * 
	 */
	public IRecordType[] getRecordType();

}
