/*******************************************************************************
 * Copyright (c) 2009 SAS Institute, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.sdd.op.listener;

/**
 * The purpose for this class is to group a set of interfaces together
 * so that we can easily tell whether or not tasks depend on notifications.
 * All Listener interfaces should subclass this interface.  That way,
 * when we're trying to figure out what tasks might have done work
 * outside of the usual execute/postExecute work flow, we can simply
 * check to see if the task is an instance of InstallListener.  If it is,
 * we know that it had the potential to do work that needs rolling back
 * even if no tasks performed execute (or it never performed execute).
 * Hence, after all standard rollbacks are complete, it gets a message
 * to rollback as well, so that if it didn't receive the standard rollback
 * message, it now can.
 */
public interface InstallListener {

}
