/***********************************************************************
 * Copyright (c) 2008 CA, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     CA, Inc. - CQ 2316
 ***********************************************************************/
package org.eclipse.cosmos.me.sdd.schema.marshal.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;

import org.eclipse.cosmos.me.sdd.schema.ext.Variables;
import org.eclipse.cosmos.me.sdd.schema.marshal.Marshaller;
import org.eclipse.cosmos.me.sdd.schema.marshal.MarshallerException;

import com.sun.xml.bind.marshaller.NamespacePrefixMapper;

public class MarshallerImpl implements Marshaller {
	public <T> T unmarshal(Class<T> clazz, String filename) throws MarshallerException {
		return unmarshal(clazz, new File(filename));
	}
	
	public <T> T unmarshal(Class<T> clazz, File file) throws MarshallerException {
		return unmarshal(clazz, new StreamSource(file));
	}

	public <T> T unmarshal(Class<T> clazz, InputStream is) throws MarshallerException {
		return unmarshal(clazz, new StreamSource(is));
	}

	public <T> void marshal(Class<T> clazz, JAXBElement<T> t, String filename) throws MarshallerException {
		marshal(clazz, t, filename, new NSPrefixMapper());
	}
	
	private <T> T unmarshal(Class<T> clazz, StreamSource ss) throws MarshallerException {
		T result = null;
		try {
			JAXBContext jaxbContext = null;
			jaxbContext = JAXBContext.newInstance(clazz, Variables.class);
			Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
			JAXBElement<T> root = unmarshaller.unmarshal(ss, clazz);
			result = root.getValue();
		} catch (Exception e) {
			throw new MarshallerException(e);
		}
		return result;
	}
	
	private <T> void marshal(Class<T> clazz, JAXBElement<T> t, String filename, NamespacePrefixMapper mapper) throws MarshallerException {
		try {
			JAXBContext jaxbContext = JAXBContext.newInstance(clazz, Variables.class);
			javax.xml.bind.Marshaller marshaller = jaxbContext.createMarshaller();
			marshaller.setProperty(javax.xml.bind.Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);
			marshaller.setProperty(javax.xml.bind.Marshaller.JAXB_ENCODING, "UTF-8");
			if (mapper != null) {
				marshaller.setProperty("com.sun.xml.bind.namespacePrefixMapper", mapper);
			}
			marshaller.marshal(t, new FileOutputStream(new File(filename)));
		} catch (Exception e) {
			throw new MarshallerException(e);
		}
	}
}
