/*******************************************************************************
 * Copyright (c) 2008 IBM Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *******************************************************************************/
package org.eclipse.cosmos.dr.internal.web.ui.viewer.handler;

import org.eclipse.cosmos.internal.dr.drs.service.handler.common.LoggerWrapper;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.SimpleLoggerWrapper;
import org.eclipse.cosmos.internal.dr.drs.service.handler.common.URLDelegator;
import org.eclipse.cosmos.provisional.dr.drs.service.handler.common.AbstractServletHandler;

public class WorkspaceURLDelegator extends URLDelegator {

	
	public WorkspaceURLDelegator() {
		super();
	}

	/**
	 * 
	 */
	private static final long serialVersionUID = -7588057729032133355L;

	@Override
	protected AbstractServletHandler createOutputterDelegator() {
		return new WorkspaceOutputterDelegator();
	}

	@Override
	protected void setLogger() {
		LoggerWrapper.setLogwrapper(new SimpleLoggerWrapper());
	}

}
