/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.dc.internal.stat.datamgr.client;

import java.util.Collection;
import org.eclipse.cosmos.dc.internal.stat.datamgr.client.StatisticalDataManagerClient;
import org.eclipse.cosmos.dc.internal.stat.datamgr.client.StatisticalTuple;
import org.eclipse.cosmos.dc.internal.stat.datamgr.common.DataSourceKeyset;

class TestStatClient {
    public static final String MY_EPR = "http://localhost:8080/org.eclipse.cosmos.dc.internal.stat.datamgr/services/StatisticalDataManager";
    private String _epr = null;

    public static void main(String[] args) {
        TestStatClient tc = null;
        tc = args.length == 0 ? new TestStatClient() : new TestStatClient(args[0]);
        tc.testGDK();
        tc.testSDFS();
    }

    public TestStatClient() {
        this._epr = new String(MY_EPR);
    }

    public TestStatClient(String epr) {
        this._epr = new String(epr);
    }

    public void testGDK() {
        StatisticalDataManagerClient c = null;
        try {
            c = new StatisticalDataManagerClient(this._epr);
        }
        catch (Exception e) {
            System.out.println("EEK");
            e.printStackTrace();
            return;
        }
        Collection<DataSourceKeyset> ret = null;
        try {
            ret = c.getDatasourceKeyset();
        }
        catch (Exception e) {
            System.out.println("response trouble.");
            e.printStackTrace();
            return;
        }
        for (DataSourceKeyset d : ret) {
            System.out.println(d.toString());
        }
    }

    public void testSDFS() {
        StatisticalDataManagerClient c = null;
        try {
            c = new StatisticalDataManagerClient(this._epr);
        }
        catch (Exception e) {
            System.out.println("EEK");
            e.printStackTrace();
            return;
        }
        Collection<StatisticalTuple> ret = null;
        String dataset = "server 33 tomcat1181829221515";
        String keyset = "CBE";
        try {
            ret = c.getStatDataForSource(dataset, keyset, 0, 1000);
        }
        catch (Exception e) {
            System.out.println("response trouble.");
            e.printStackTrace();
            return;
        }
        for (StatisticalTuple t : ret) {
            System.out.println("Tuple " + t.toString());
        }
    }
}

