/*******************************************************************************
 * Copyright (c) 2009 SAS Institute, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.sdd.cr;

import java.util.HashMap;
import java.util.Set;

/**
 * Class to represent data that describes a defined constraint that an implementation of a resolver would use
 * for data comparison.
 * @author jehamm
 *
 */
public class Constraint {

	private String _type;
	private HashMap<String,String[]> _values = new HashMap<String,String[]>();
	
	/**
	 * Methods to set and get the type.
	 * @param type
	 */
	public void setType(String type) {
		_type = type;
	}
	public String getType() {
		return _type;
	}	
	public Set<String> getNames() {
		return _values.keySet();
	}
	/**
	 * Method to set a value.
	 * @param name
	 * @param value
	 */
	public void setValue(String name, String value) {
		_values.put(name, new String[] {value});
	}
	
	/**
	 * Values are stores as an array because you may have multiple variables to compare against.
	 * @param name
	 * @return
	 */
	public String[] getValues(String name) {
		return (String[]) _values.get(name);
	}
	
	public void setValues(String name, String[] values) {
		_values.put(name, values);
	}
	
	/**
	 * Display the contents of this instance.
	 */
	public String toString() {
		
		StringBuffer buffer = new StringBuffer();
		buffer.append("\nConstraint->type:" + _type).append("\n");
		
		for(String key : _values.keySet()) {
			String[] vals = (String [])_values.get(key);
			for(int i = 0; i < vals.length; i++) {
				buffer.append("attribute/value:" + key + "/" + vals[i]).append("\n");
			}
		}
		return buffer.toString();
	}
	
	private String _status ="rejected";
	public void accept() {
		_status= "accepted";
	}
	public void reject() {
		_status = "rejected";
	}
	public String getStatus() {
		return _status;
	}
	public boolean isAccepted() {
		return (_status.equalsIgnoreCase("accepted") ? true : false);
	}
	public boolean isRejected() {
		return (_status.equalsIgnoreCase("rejected") ? true : false);
	}
	
	/**
	 * Defines the name of the resource.
	 * TODO -- this may need to be expanded to contain the entire resource in case there are multiple properties involved.
	 */
	private String _resource;
	public void setResource(String resource) {
		_resource = resource;
	}
	public String getResource() {
		return _resource;
	}
}
